// clang-format off
// SPDX-FileCopyrightText: © 2019, 2021-2022 Alexandros Theodotou <alex@zrythm.org>
// SPDX-License-Identifier: LicenseRef-ZrythmLicense
// clang-format on

/**
 * @file
 *
 * Arranger minimap selection.
 */

#ifndef __GUI_WIDGETS_ARRANGER_MINIMAP_SELECTION_H__
#define __GUI_WIDGETS_ARRANGER_MINIMAP_SELECTION_H__

#include "utils/ui.h"

#include <gtk/gtk.h>

/**
 * @addtogroup widgets
 *
 * @{
 */

#define ARRANGER_MINIMAP_SELECTION_WIDGET_TYPE \
  (arranger_minimap_selection_widget_get_type ())
G_DECLARE_FINAL_TYPE (
  ArrangerMinimapSelectionWidget,
  arranger_minimap_selection_widget,
  Z,
  ARRANGER_MINIMAP_SELECTION_WIDGET,
  GtkWidget)

typedef struct _ArrangerMinimapSelectionWidget
{
  GtkWidget parent_instance;

  UiCursorState cursor;

  /** Pointer back to parent. */
  ArrangerMinimapWidget * parent;
} ArrangerMinimapSelectionWidget;

ArrangerMinimapSelectionWidget *
arranger_minimap_selection_widget_new (ArrangerMinimapWidget * parent);

#if 0
void
arranger_minimap_selection_widget_on_motion (
  GtkWidget *      widget,
  GdkMotionEvent * event,
  gpointer         user_data);
#endif

/**
 * @}
 */

#endif
