// SPDX-FileCopyrightText: © 2020 Alexandros Theodotou <alex@zrythm.org>
// SPDX-License-Identifier: LicenseRef-ZrythmLicense

/**
 * @file
 *
 * This file must only be included in
 * utils/localization.c.
 *
 * Each array can be accessed via localization_*()
 * wrappers.
 */

#ifndef __PO_LOCALES_H__
#define __PO_LOCALES_H__

const char * language_codes[] = {
  "af_ZA",
  "ar",
  "ca",
  "de",
  "el",
  "en",
  "en_GB",
  "es",
  "fa",
  "fr",
  "gl",
  "he",
  "hi",
  "hu",
  "id",
  "it",
  "ja",
  "ko",
  "nb_NO",
  "mk",
  "nl",
  "pl",
  "pt",
  "pt_BR",
  "ru",
  "sv",
  "th",
  "tr",
  "uk",
  "vi",
  "zh_CN",
  "zh_TW",

};

const char * language_strings[] = {
  "Afrikaans",
  "اَلْعَرَبِيَّةُ‎",
  "Català",
  "Deutsch",
  "Ελληνικά",
  "English",
  "English UK",
  "Español",
  "فارسی",
  "Français",
  "Galego",
  "עִבְרִית",
  "हिन्दी",
  "magyar nyelv",
  "bahasa Indonesia",
  "Italiano",
  "日本語",
  "한국어",
  "Bokmål",
  "македонски",
  "Nederlands",
  "Polski",
  "Português",
  "Português BR",
  "Русский",
  "Svenska",
  "ภาษาไทย",
  "Türkiye",
  "Українська",
  "Tiếng Việt",
  "简体中文",
  "繁體中文",

};

const char * language_strings_w_codes[] = {
  "Afrikaans [af_ZA]",
  "اَلْعَرَبِيَّةُ‎ [ar]",
  "Català [ca]",
  "Deutsch [de]",
  "Ελληνικά [el]",
  "English [en]",
  "English UK [en_GB]",
  "Español [es]",
  "فارسی [fa]",
  "Français [fr]",
  "Galego [gl]",
  "עִבְרִית [he]",
  "हिन्दी [hi]",
  "magyar nyelv [hu]",
  "bahasa Indonesia [id]",
  "Italiano [it]",
  "日本語 [ja]",
  "한국어 [ko]",
  "Bokmål [nb_NO]",
  "македонски [mk]",
  "Nederlands [nl]",
  "Polski [pl]",
  "Português [pt]",
  "Português BR [pt_BR]",
  "Русский [ru]",
  "Svenska [sv]",
  "ภาษาไทย [th]",
  "Türkiye [tr]",
  "Українська [uk]",
  "Tiếng Việt [vi]",
  "简体中文 [zh_CN]",
  "繁體中文 [zh_TW]",

};

#endif
