/* Generated by wayland-scanner 1.22.0 */

#ifndef DRM_LEASE_V1_CLIENT_PROTOCOL_H
#define DRM_LEASE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_drm_lease_v1 The drm_lease_v1 protocol
 * @section page_ifaces_drm_lease_v1 Interfaces
 * - @subpage page_iface_wp_drm_lease_device_v1 - lease device
 * - @subpage page_iface_wp_drm_lease_connector_v1 - a leasable DRM connector
 * - @subpage page_iface_wp_drm_lease_request_v1 - DRM lease request
 * - @subpage page_iface_wp_drm_lease_v1 - a DRM lease
 * @section page_copyright_drm_lease_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 NXP
 * Copyright © 2019 Status Research & Development GmbH.
 * Copyright © 2021 Xaver Hugl
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wp_drm_lease_connector_v1;
struct wp_drm_lease_device_v1;
struct wp_drm_lease_request_v1;
struct wp_drm_lease_v1;

#ifndef WP_DRM_LEASE_DEVICE_V1_INTERFACE
#define WP_DRM_LEASE_DEVICE_V1_INTERFACE
/**
 * @page page_iface_wp_drm_lease_device_v1 wp_drm_lease_device_v1
 * @section page_iface_wp_drm_lease_device_v1_desc Description
 *
 * This protocol is used by Wayland compositors which act as Direct
 * Rendering Manager (DRM) masters to lease DRM resources to Wayland
 * clients.
 *
 * The compositor will advertise one wp_drm_lease_device_v1 global for each
 * DRM node. Some time after a client binds to the wp_drm_lease_device_v1
 * global, the compositor will send a drm_fd event followed by zero, one or
 * more connector events. After all currently available connectors have been
 * sent, the compositor will send a wp_drm_lease_device_v1.done event.
 *
 * When the list of connectors available for lease changes the compositor
 * will send wp_drm_lease_device_v1.connector events for added connectors and
 * wp_drm_lease_connector_v1.withdrawn events for removed connectors,
 * followed by a wp_drm_lease_device_v1.done event.
 *
 * The compositor will indicate when a device is gone by removing the global
 * via a wl_registry.global_remove event. Upon receiving this event, the
 * client should destroy any matching wp_drm_lease_device_v1 object.
 *
 * To destroy a wp_drm_lease_device_v1 object, the client must first issue
 * a release request. Upon receiving this request, the compositor will
 * immediately send a released event and destroy the object. The client must
 * continue to process and discard drm_fd and connector events until it
 * receives the released event. Upon receiving the released event, the
 * client can safely cleanup any client-side resources.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_drm_lease_device_v1_api API
 * See @ref iface_wp_drm_lease_device_v1.
 */
/**
 * @defgroup iface_wp_drm_lease_device_v1 The wp_drm_lease_device_v1 interface
 *
 * This protocol is used by Wayland compositors which act as Direct
 * Rendering Manager (DRM) masters to lease DRM resources to Wayland
 * clients.
 *
 * The compositor will advertise one wp_drm_lease_device_v1 global for each
 * DRM node. Some time after a client binds to the wp_drm_lease_device_v1
 * global, the compositor will send a drm_fd event followed by zero, one or
 * more connector events. After all currently available connectors have been
 * sent, the compositor will send a wp_drm_lease_device_v1.done event.
 *
 * When the list of connectors available for lease changes the compositor
 * will send wp_drm_lease_device_v1.connector events for added connectors and
 * wp_drm_lease_connector_v1.withdrawn events for removed connectors,
 * followed by a wp_drm_lease_device_v1.done event.
 *
 * The compositor will indicate when a device is gone by removing the global
 * via a wl_registry.global_remove event. Upon receiving this event, the
 * client should destroy any matching wp_drm_lease_device_v1 object.
 *
 * To destroy a wp_drm_lease_device_v1 object, the client must first issue
 * a release request. Upon receiving this request, the compositor will
 * immediately send a released event and destroy the object. The client must
 * continue to process and discard drm_fd and connector events until it
 * receives the released event. Upon receiving the released event, the
 * client can safely cleanup any client-side resources.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_drm_lease_device_v1_interface;
#endif
#ifndef WP_DRM_LEASE_CONNECTOR_V1_INTERFACE
#define WP_DRM_LEASE_CONNECTOR_V1_INTERFACE
/**
 * @page page_iface_wp_drm_lease_connector_v1 wp_drm_lease_connector_v1
 * @section page_iface_wp_drm_lease_connector_v1_desc Description
 *
 * Represents a DRM connector which is available for lease. These objects are
 * created via wp_drm_lease_device_v1.connector events, and should be passed
 * to lease requests via wp_drm_lease_request_v1.request_connector.
 * Immediately after the wp_drm_lease_connector_v1 object is created the
 * compositor will send a name, a description, a connector_id and a done
 * event. When the description is updated the compositor will send a
 * description event followed by a done event.
 * @section page_iface_wp_drm_lease_connector_v1_api API
 * See @ref iface_wp_drm_lease_connector_v1.
 */
/**
 * @defgroup iface_wp_drm_lease_connector_v1 The wp_drm_lease_connector_v1 interface
 *
 * Represents a DRM connector which is available for lease. These objects are
 * created via wp_drm_lease_device_v1.connector events, and should be passed
 * to lease requests via wp_drm_lease_request_v1.request_connector.
 * Immediately after the wp_drm_lease_connector_v1 object is created the
 * compositor will send a name, a description, a connector_id and a done
 * event. When the description is updated the compositor will send a
 * description event followed by a done event.
 */
extern const struct wl_interface wp_drm_lease_connector_v1_interface;
#endif
#ifndef WP_DRM_LEASE_REQUEST_V1_INTERFACE
#define WP_DRM_LEASE_REQUEST_V1_INTERFACE
/**
 * @page page_iface_wp_drm_lease_request_v1 wp_drm_lease_request_v1
 * @section page_iface_wp_drm_lease_request_v1_desc Description
 *
 * A client that wishes to lease DRM resources will attach the list of
 * connectors advertised with wp_drm_lease_device_v1.connector that they
 * wish to lease, then use wp_drm_lease_request_v1.submit to submit the
 * request.
 * @section page_iface_wp_drm_lease_request_v1_api API
 * See @ref iface_wp_drm_lease_request_v1.
 */
/**
 * @defgroup iface_wp_drm_lease_request_v1 The wp_drm_lease_request_v1 interface
 *
 * A client that wishes to lease DRM resources will attach the list of
 * connectors advertised with wp_drm_lease_device_v1.connector that they
 * wish to lease, then use wp_drm_lease_request_v1.submit to submit the
 * request.
 */
extern const struct wl_interface wp_drm_lease_request_v1_interface;
#endif
#ifndef WP_DRM_LEASE_V1_INTERFACE
#define WP_DRM_LEASE_V1_INTERFACE
/**
 * @page page_iface_wp_drm_lease_v1 wp_drm_lease_v1
 * @section page_iface_wp_drm_lease_v1_desc Description
 *
 * A DRM lease object is used to transfer the DRM file descriptor to the
 * client and manage the lifetime of the lease.
 *
 * Some time after the wp_drm_lease_v1 object is created, the compositor
 * will reply with the lease request's result. If the lease request is
 * granted, the compositor will send a lease_fd event. If the lease request
 * is denied, the compositor will send a finished event without a lease_fd
 * event.
 * @section page_iface_wp_drm_lease_v1_api API
 * See @ref iface_wp_drm_lease_v1.
 */
/**
 * @defgroup iface_wp_drm_lease_v1 The wp_drm_lease_v1 interface
 *
 * A DRM lease object is used to transfer the DRM file descriptor to the
 * client and manage the lifetime of the lease.
 *
 * Some time after the wp_drm_lease_v1 object is created, the compositor
 * will reply with the lease request's result. If the lease request is
 * granted, the compositor will send a lease_fd event. If the lease request
 * is denied, the compositor will send a finished event without a lease_fd
 * event.
 */
extern const struct wl_interface wp_drm_lease_v1_interface;
#endif

/**
 * @ingroup iface_wp_drm_lease_device_v1
 * @struct wp_drm_lease_device_v1_listener
 */
struct wp_drm_lease_device_v1_listener {
	/**
	 * open a non-master fd for this DRM node
	 *
	 * The compositor will send this event when the
	 * wp_drm_lease_device_v1 global is bound, although there are no
	 * guarantees as to how long this takes - the compositor might need
	 * to wait until regaining DRM master. The included fd is a
	 * non-master DRM file descriptor opened for this device and the
	 * compositor must not authenticate it. The purpose of this event
	 * is to give the client the ability to query DRM and discover
	 * information which may help them pick the appropriate DRM device
	 * or select the appropriate connectors therein.
	 * @param fd DRM file descriptor
	 */
	void (*drm_fd)(void *data,
		       struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1,
		       int32_t fd);
	/**
	 * advertise connectors available for leases
	 *
	 * The compositor will use this event to advertise connectors
	 * available for lease by clients. This object may be passed into a
	 * lease request to indicate the client would like to lease that
	 * connector, see wp_drm_lease_request_v1.request_connector for
	 * details. While the compositor will make a best effort to not
	 * send disconnected connectors, no guarantees can be made.
	 *
	 * The compositor must send the drm_fd event before sending
	 * connectors. After the drm_fd event it will send all available
	 * connectors but may send additional connectors at any time.
	 */
	void (*connector)(void *data,
			  struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1,
			  struct wp_drm_lease_connector_v1 *id);
	/**
	 * signals grouping of connectors
	 *
	 * The compositor will send this event to indicate that it has
	 * sent all currently available connectors after the client binds
	 * to the global or when it updates the connector list, for example
	 * on hotplug, drm master change or when a leased connector becomes
	 * available again. It will similarly send this event to group
	 * wp_drm_lease_connector_v1.withdrawn events of connectors of this
	 * device.
	 */
	void (*done)(void *data,
		     struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1);
	/**
	 * the compositor has finished using the device
	 *
	 * This event is sent in response to the release request and
	 * indicates that the compositor is done sending connector events.
	 * The compositor will destroy this object immediately after
	 * sending the event and it will become invalid. The client should
	 * release any resources associated with this device after
	 * receiving this event.
	 */
	void (*released)(void *data,
			 struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1);
};

/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
static inline int
wp_drm_lease_device_v1_add_listener(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1,
				    const struct wp_drm_lease_device_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) wp_drm_lease_device_v1,
				     (void (**)(void)) listener, data);
}

#define WP_DRM_LEASE_DEVICE_V1_CREATE_LEASE_REQUEST 0
#define WP_DRM_LEASE_DEVICE_V1_RELEASE 1

/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_DRM_FD_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_CONNECTOR_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_RELEASED_SINCE_VERSION 1

/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_CREATE_LEASE_REQUEST_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_device_v1
 */
#define WP_DRM_LEASE_DEVICE_V1_RELEASE_SINCE_VERSION 1

/** @ingroup iface_wp_drm_lease_device_v1 */
static inline void
wp_drm_lease_device_v1_set_user_data(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_drm_lease_device_v1, user_data);
}

/** @ingroup iface_wp_drm_lease_device_v1 */
static inline void *
wp_drm_lease_device_v1_get_user_data(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_drm_lease_device_v1);
}

static inline uint32_t
wp_drm_lease_device_v1_get_version(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_device_v1);
}

/** @ingroup iface_wp_drm_lease_device_v1 */
static inline void
wp_drm_lease_device_v1_destroy(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1)
{
	wl_proxy_destroy((struct wl_proxy *) wp_drm_lease_device_v1);
}

/**
 * @ingroup iface_wp_drm_lease_device_v1
 *
 * Creates a lease request object.
 *
 * See the documentation for wp_drm_lease_request_v1 for details.
 */
static inline struct wp_drm_lease_request_v1 *
wp_drm_lease_device_v1_create_lease_request(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_device_v1,
			 WP_DRM_LEASE_DEVICE_V1_CREATE_LEASE_REQUEST, &wp_drm_lease_request_v1_interface, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_device_v1), 0, NULL);

	return (struct wp_drm_lease_request_v1 *) id;
}

/**
 * @ingroup iface_wp_drm_lease_device_v1
 *
 * Indicates the client no longer wishes to use this object. In response
 * the compositor will immediately send the released event and destroy
 * this object. It can however not guarantee that the client won't receive
 * connector events before the released event. The client must not send any
 * requests after this one, doing so will raise a wl_display error.
 * Existing connectors, lease request and leases will not be affected.
 */
static inline void
wp_drm_lease_device_v1_release(struct wp_drm_lease_device_v1 *wp_drm_lease_device_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_device_v1,
			 WP_DRM_LEASE_DEVICE_V1_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_device_v1), 0);
}

/**
 * @ingroup iface_wp_drm_lease_connector_v1
 * @struct wp_drm_lease_connector_v1_listener
 */
struct wp_drm_lease_connector_v1_listener {
	/**
	 * name
	 *
	 * The compositor sends this event once the connector is created
	 * to indicate the name of this connector. This will not change for
	 * the duration of the Wayland session, but is not guaranteed to be
	 * consistent between sessions.
	 *
	 * If the compositor supports wl_output version 4 and this
	 * connector corresponds to a wl_output, the compositor should use
	 * the same name as for the wl_output.
	 * @param name connector name
	 */
	void (*name)(void *data,
		     struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1,
		     const char *name);
	/**
	 * description
	 *
	 * The compositor sends this event once the connector is created
	 * to provide a human-readable description for this connector,
	 * which may be presented to the user. The compositor may send this
	 * event multiple times over the lifetime of this object to reflect
	 * changes in the description.
	 * @param description connector description
	 */
	void (*description)(void *data,
			    struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1,
			    const char *description);
	/**
	 * connector_id
	 *
	 * The compositor sends this event once the connector is created
	 * to indicate the DRM object ID which represents the underlying
	 * connector that is being offered. Note that the final lease may
	 * include additional object IDs, such as CRTCs and planes.
	 * @param connector_id DRM connector ID
	 */
	void (*connector_id)(void *data,
			     struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1,
			     uint32_t connector_id);
	/**
	 * all properties have been sent
	 *
	 * This event is sent after all properties of a connector have
	 * been sent. This allows changes to the properties to be seen as
	 * atomic even if they happen via multiple events.
	 */
	void (*done)(void *data,
		     struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1);
	/**
	 * lease offer withdrawn
	 *
	 * Sent to indicate that the compositor will no longer honor
	 * requests for DRM leases which include this connector. The client
	 * may still issue a lease request including this connector, but
	 * the compositor will send wp_drm_lease_v1.finished without
	 * issuing a lease fd. Compositors are encouraged to send this
	 * event when they lose access to connector, for example when the
	 * connector is hot-unplugged, when the connector gets leased to a
	 * client or when the compositor loses DRM master.
	 */
	void (*withdrawn)(void *data,
			  struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1);
};

/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
static inline int
wp_drm_lease_connector_v1_add_listener(struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1,
				       const struct wp_drm_lease_connector_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) wp_drm_lease_connector_v1,
				     (void (**)(void)) listener, data);
}

#define WP_DRM_LEASE_CONNECTOR_V1_DESTROY 0

/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_CONNECTOR_ID_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_WITHDRAWN_SINCE_VERSION 1

/**
 * @ingroup iface_wp_drm_lease_connector_v1
 */
#define WP_DRM_LEASE_CONNECTOR_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_wp_drm_lease_connector_v1 */
static inline void
wp_drm_lease_connector_v1_set_user_data(struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_drm_lease_connector_v1, user_data);
}

/** @ingroup iface_wp_drm_lease_connector_v1 */
static inline void *
wp_drm_lease_connector_v1_get_user_data(struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_drm_lease_connector_v1);
}

static inline uint32_t
wp_drm_lease_connector_v1_get_version(struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_connector_v1);
}

/**
 * @ingroup iface_wp_drm_lease_connector_v1
 *
 * The client may send this request to indicate that it will not use this
 * connector. Clients are encouraged to send this after receiving the
 * "withdrawn" event so that the server can release the resources
 * associated with this connector offer. Neither existing lease requests
 * nor leases will be affected.
 */
static inline void
wp_drm_lease_connector_v1_destroy(struct wp_drm_lease_connector_v1 *wp_drm_lease_connector_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_connector_v1,
			 WP_DRM_LEASE_CONNECTOR_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_connector_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef WP_DRM_LEASE_REQUEST_V1_ERROR_ENUM
#define WP_DRM_LEASE_REQUEST_V1_ERROR_ENUM
enum wp_drm_lease_request_v1_error {
	/**
	 * requested a connector from a different lease device
	 */
	WP_DRM_LEASE_REQUEST_V1_ERROR_WRONG_DEVICE = 0,
	/**
	 * requested a connector twice
	 */
	WP_DRM_LEASE_REQUEST_V1_ERROR_DUPLICATE_CONNECTOR = 1,
	/**
	 * requested a lease without requesting a connector
	 */
	WP_DRM_LEASE_REQUEST_V1_ERROR_EMPTY_LEASE = 2,
};
#endif /* WP_DRM_LEASE_REQUEST_V1_ERROR_ENUM */

#define WP_DRM_LEASE_REQUEST_V1_REQUEST_CONNECTOR 0
#define WP_DRM_LEASE_REQUEST_V1_SUBMIT 1


/**
 * @ingroup iface_wp_drm_lease_request_v1
 */
#define WP_DRM_LEASE_REQUEST_V1_REQUEST_CONNECTOR_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_request_v1
 */
#define WP_DRM_LEASE_REQUEST_V1_SUBMIT_SINCE_VERSION 1

/** @ingroup iface_wp_drm_lease_request_v1 */
static inline void
wp_drm_lease_request_v1_set_user_data(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_drm_lease_request_v1, user_data);
}

/** @ingroup iface_wp_drm_lease_request_v1 */
static inline void *
wp_drm_lease_request_v1_get_user_data(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_drm_lease_request_v1);
}

static inline uint32_t
wp_drm_lease_request_v1_get_version(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_request_v1);
}

/** @ingroup iface_wp_drm_lease_request_v1 */
static inline void
wp_drm_lease_request_v1_destroy(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1)
{
	wl_proxy_destroy((struct wl_proxy *) wp_drm_lease_request_v1);
}

/**
 * @ingroup iface_wp_drm_lease_request_v1
 *
 * Indicates that the client would like to lease the given connector.
 * This is only used as a suggestion, the compositor may choose to
 * include any resources in the lease it issues, or change the set of
 * leased resources at any time. Compositors are however encouraged to
 * include the requested connector and other resources necessary
 * to drive the connected output in the lease.
 *
 * Requesting a connector that was created from a different lease device
 * than this lease request raises the wrong_device error. Requesting a
 * connector twice will raise the duplicate_connector error.
 */
static inline void
wp_drm_lease_request_v1_request_connector(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1, struct wp_drm_lease_connector_v1 *connector)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_request_v1,
			 WP_DRM_LEASE_REQUEST_V1_REQUEST_CONNECTOR, NULL, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_request_v1), 0, connector);
}

/**
 * @ingroup iface_wp_drm_lease_request_v1
 *
 * Submits the lease request and creates a new wp_drm_lease_v1 object.
 * After calling submit the compositor will immediately destroy this
 * object, issuing any more requests will cause a wl_diplay error.
 * The compositor doesn't make any guarantees about the events of the
 * lease object, clients cannot expect an immediate response.
 * Not requesting any connectors before submitting the lease request
 * will raise the empty_lease error.
 */
static inline struct wp_drm_lease_v1 *
wp_drm_lease_request_v1_submit(struct wp_drm_lease_request_v1 *wp_drm_lease_request_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_request_v1,
			 WP_DRM_LEASE_REQUEST_V1_SUBMIT, &wp_drm_lease_v1_interface, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_request_v1), WL_MARSHAL_FLAG_DESTROY, NULL);

	return (struct wp_drm_lease_v1 *) id;
}

/**
 * @ingroup iface_wp_drm_lease_v1
 * @struct wp_drm_lease_v1_listener
 */
struct wp_drm_lease_v1_listener {
	/**
	 * shares the DRM file descriptor
	 *
	 * This event returns a file descriptor suitable for use with
	 * DRM-related ioctls. The client should use drmModeGetLease to
	 * enumerate the DRM objects which have been leased to them. The
	 * compositor guarantees it will not use the leased DRM objects
	 * itself until it sends the finished event. If the compositor
	 * cannot or will not grant a lease for the requested connectors,
	 * it will not send this event, instead sending the finished event.
	 *
	 * The compositor will send this event at most once during this
	 * objects lifetime.
	 * @param leased_fd leased DRM file descriptor
	 */
	void (*lease_fd)(void *data,
			 struct wp_drm_lease_v1 *wp_drm_lease_v1,
			 int32_t leased_fd);
	/**
	 * sent when the lease has been revoked
	 *
	 * The compositor uses this event to either reject a lease
	 * request, or if it previously sent a lease_fd, to notify the
	 * client that the lease has been revoked. If the client requires a
	 * new lease, they should destroy this object and submit a new
	 * lease request. The compositor will send no further events for
	 * this object after sending the finish event. Compositors should
	 * revoke the lease when any of the leased resources become
	 * unavailable, namely when a hot-unplug occurs or when the
	 * compositor loses DRM master.
	 */
	void (*finished)(void *data,
			 struct wp_drm_lease_v1 *wp_drm_lease_v1);
};

/**
 * @ingroup iface_wp_drm_lease_v1
 */
static inline int
wp_drm_lease_v1_add_listener(struct wp_drm_lease_v1 *wp_drm_lease_v1,
			     const struct wp_drm_lease_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) wp_drm_lease_v1,
				     (void (**)(void)) listener, data);
}

#define WP_DRM_LEASE_V1_DESTROY 0

/**
 * @ingroup iface_wp_drm_lease_v1
 */
#define WP_DRM_LEASE_V1_LEASE_FD_SINCE_VERSION 1
/**
 * @ingroup iface_wp_drm_lease_v1
 */
#define WP_DRM_LEASE_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_wp_drm_lease_v1
 */
#define WP_DRM_LEASE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_wp_drm_lease_v1 */
static inline void
wp_drm_lease_v1_set_user_data(struct wp_drm_lease_v1 *wp_drm_lease_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wp_drm_lease_v1, user_data);
}

/** @ingroup iface_wp_drm_lease_v1 */
static inline void *
wp_drm_lease_v1_get_user_data(struct wp_drm_lease_v1 *wp_drm_lease_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wp_drm_lease_v1);
}

static inline uint32_t
wp_drm_lease_v1_get_version(struct wp_drm_lease_v1 *wp_drm_lease_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_v1);
}

/**
 * @ingroup iface_wp_drm_lease_v1
 *
 * The client should send this to indicate that it no longer wishes to use
 * this lease. The compositor should use drmModeRevokeLease on the
 * appropriate file descriptor, if necessary.
 */
static inline void
wp_drm_lease_v1_destroy(struct wp_drm_lease_v1 *wp_drm_lease_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wp_drm_lease_v1,
			 WP_DRM_LEASE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) wp_drm_lease_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
