"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeSpan = void 0;
const moment = require("moment-timezone");
const ArgumentException_1 = require("../js/Exceptions/ArgumentException");
class TimeSpan {
    constructor(daysOrHoursOrMsOrDuration, hoursOrMinutes, minutesOrSeconds, seconds, milliseconds) {
        let duration = null;
        let argsLength = arguments.length;
        if (argsLength === 1) {
            duration = moment.duration(daysOrHoursOrMsOrDuration);
        }
        else {
            let momentInput = {};
            if (argsLength === 3) {
                momentInput.hours = daysOrHoursOrMsOrDuration;
                momentInput.minutes = hoursOrMinutes;
                momentInput.seconds = minutesOrSeconds;
            }
            if (argsLength >= 4) {
                momentInput.days = daysOrHoursOrMsOrDuration;
                momentInput.hours = hoursOrMinutes;
                momentInput.minutes = minutesOrSeconds;
                momentInput.seconds = seconds;
            }
            if (argsLength === 5) {
                momentInput.millisecond = milliseconds;
            }
            duration = moment.duration(momentInput);
        }
        this.getMomentDuration = () => duration;
        this.setMomentDuration = (value) => duration = value;
    }
    get duration() { return this.getMomentDuration(); }
    humanize(withSuffix) { return this.duration.humanize(withSuffix); }
    as(units) { return this.duration.as(units); }
    get Milliseconds() {
        return this.duration.milliseconds();
    }
    get TotalMilliseconds() {
        return this.duration.asMilliseconds();
    }
    get Seconds() {
        return this.duration.seconds();
    }
    get TotalSeconds() {
        return this.duration.asSeconds();
    }
    get Minutes() {
        return this.duration.minutes();
    }
    get TotalMinutes() {
        return this.duration.asMinutes();
    }
    get Hours() {
        return this.duration.hours();
    }
    get TotalHours() {
        return this.duration.asHours();
    }
    get Days() {
        return this.duration.days();
    }
    get TotalDays() {
        return this.duration.asDays();
    }
    get Months() {
        return this.duration.months();
    }
    get TotalMonths() {
        return this.duration.asMonths();
    }
    get Years() {
        return this.duration.years();
    }
    get TotalYears() {
        return this.duration.asYears();
    }
    get Weeks() {
        return this.duration.weeks();
    }
    get Totalweeks() {
        return this.duration.asWeeks();
    }
    Add(a, p) {
        if (arguments.length === 1) {
            return new TimeSpan(typeof a === 'number' ? this.duration.add(a) : a.TotalMilliseconds);
        }
        else {
            return new TimeSpan(this.duration.add(a, p));
        }
    }
    Subtract(a, p) {
        if (arguments.length === 1) {
            return new TimeSpan(this.duration.subtract(a));
        }
        else {
            return new TimeSpan(this.duration.subtract(a, p));
        }
    }
    ToISOString() { return this.duration.toISOString(); }
    ToJSON() { return this.duration.toJSON(); }
    static FromDays(value) {
        return new TimeSpan(value * TimeSpan.MillisPerDay);
    }
    static FromHours(value) {
        return new TimeSpan(value * TimeSpan.MillisPerHour);
    }
    static FromMilliseconds(value) {
        return new TimeSpan(value);
    }
    static FromMinutes(value) {
        return new TimeSpan(value * TimeSpan.MillisPerMinute);
    }
    static FromSeconds(value) {
        return new TimeSpan(value * TimeSpan.MillisPerSecond);
    }
    valueOf() {
        return this.duration.asMilliseconds();
    }
    toString() {
        return this.duration.toISOString();
    }
}
exports.TimeSpan = TimeSpan;
/** @internal */
TimeSpan.MillisPerSecond = 1000; //const
/** @internal */
TimeSpan.MillisPerMinute = TimeSpan.MillisPerSecond * 60; //     60,000 //const
/** @internal */
TimeSpan.MillisPerHour = TimeSpan.MillisPerMinute * 60; //  3,600,000 //const
/** @internal */
TimeSpan.MillisPerDay = TimeSpan.MillisPerHour * 24; // 86,400,000 //const
TimeSpan.MaxSeconds = Number.MAX_VALUE / TimeSpan.MillisPerSecond; // TimeSpan.TicksPerSecond; //const
TimeSpan.MinSeconds = Number.MIN_VALUE / TimeSpan.MillisPerSecond; // TimeSpan.TicksPerSecond; //const
TimeSpan.MaxMilliSeconds = Number.MAX_VALUE; /// TimeSpan.TicksPerMillisecond; //const
TimeSpan.MinMilliSeconds = Number.MIN_VALUE; /// TimeSpan.TicksPerMillisecond; //const
//private static  TicksPerTenthSecond:number = TimeSpan.TicksPerMillisecond * 100; //const
TimeSpan.Zero = new TimeSpan(0); //readonly
TimeSpan.MaxValueTimeSpan = new TimeSpan(Number.MAX_VALUE); //readonly
TimeSpan.MinValueTimeSpan = new TimeSpan(Number.MIN_VALUE); //readonly
var TimeSpan2;
(function (TimeSpan2) {
    /** TimeSpan basics from c# using momentjs */
    class TimeSpan {
        constructor(millisOrHrsOrDays, minsOrHrs, secsOrMins, seconds, milliseconds) {
            this._millis = 0;
            let argsLength = arguments.length;
            let millis = 0;
            if (typeof milliseconds !== 'undefined')
                millis = milliseconds;
            switch (argsLength) {
                case 1:
                    this._millis = millisOrHrsOrDays;
                    break;
                case 3:
                    this._millis = TimeSpan.TimeToTicks(millisOrHrsOrDays, minsOrHrs, secsOrMins);
                    break;
                case 4:
                case 5:
                    let totalSeconds = millisOrHrsOrDays * 24 * 3600 + minsOrHrs * 3600 + secsOrMins * 60 + seconds;
                    if (totalSeconds > TimeSpan.MaxSeconds || totalSeconds < TimeSpan.MinSeconds)
                        throw new ArgumentException_1.ArgumentOutOfRangeException("DateTime.ts - TimeSpan.ctor - Overflow_TimeSpanTooLong");
                    this._millis = totalSeconds * TimeSpan.MillisPerSecond + millis;
                    break;
                default:
                    throw new Error("DateTime.ts - TimeSpan.ctor - invalid number of arguments");
            }
        }
        static TimeToTicks(hour, minute, second) {
            // totalSeconds is bounded by 2^31 * 2^12 + 2^31 * 2^8 + 2^31,
            // which is less than 2^44, meaning we won't overflow totalSeconds.
            let totalSeconds = hour * 3600 + minute * 60 + second;
            if (totalSeconds > this.MaxSeconds || totalSeconds < this.MinSeconds)
                throw new ArgumentException_1.ArgumentOutOfRangeException("DateTime.ts - TimeSpan.TimeToTicks - Overflow_TimeSpanTooLong");
            return totalSeconds * this.MillisPerSecond;
        }
        get Days() { return Math.floor(this._millis / TimeSpan.MillisPerDay); }
        get Hours() { return Math.floor(this._millis / TimeSpan.MillisPerHour); }
        get Milliseconds() { return Math.floor(this._millis); }
        get Minutes() { return Math.floor(this._millis / TimeSpan.MillisPerMinute); }
        get Seconds() { return Math.floor(this._millis / TimeSpan.MillisPerSecond); }
        //public get Ticks(): number { return Math.floor( this._millis / TimeSpan.); }
        get TotalDays() { return this._millis / TimeSpan.MillisPerDay; }
        get TotalHours() { return this._millis / TimeSpan.MillisPerHour; }
        get TotalMilliseconds() { return this._millis; }
        get TotalMinutes() { return this._millis / TimeSpan.MillisPerMinute; }
        get TotalSeconds() { return this._millis / TimeSpan.MillisPerSecond; }
        // Compares two TimeSpan values, returning an integer that indicates their
        // relationship.
        //
        static Compare(t1, t2) {
            if (t1._millis > t2._millis)
                return 1;
            if (t1._millis < t2._millis)
                return -1;
            return 0;
        }
        static Equals(t1, t2) { return t1._millis === t2._millis; }
        static FromDays(value) { return new TimeSpan(value * TimeSpan.MillisPerDay); }
        static FromHours(value) { return new TimeSpan(value * TimeSpan.MillisPerHour); }
        static FromMilliseconds(value) { return new TimeSpan(value); }
        static FromMinutes(value) { return new TimeSpan(value * TimeSpan.MillisPerMinute); }
        static FromSeconds(value) { return new TimeSpan(value * TimeSpan.MillisPerSecond); }
        //public static FromTicks(value: number): TimeSpan{ return new TimeSpan(value * TimeSpan.MillisPerDay); }
        static Parse(s) {
            return null;
        }
        //public static Parse(input: string, formatProvider: IFormatProvider): TimeSpan;
        //public static ParseExact(string input, string[] formats, IFormatProvider formatProvider): TimeSpan;
        //public static ParseExact(string input, string format, IFormatProvider formatProvider): TimeSpan;
        //public static ParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles): TimeSpan;
        //public static ParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles): TimeSpan;
        //public static TryParse(string s, out TimeSpan result): boolean;
        //public static TryParse(string input, IFormatProvider formatProvider, out TimeSpan result): boolean;
        //public static TryParseExact(string input, string[] formats, IFormatProvider formatProvider, out TimeSpan result): boolean;
        //public static TryParseExact(string input, string format, IFormatProvider formatProvider, out TimeSpan result): boolean;
        //public static TryParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result): boolean;
        //public static TryParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result): boolean { }
        Add(ts) {
            let result = this._millis + ts._millis;
            // Overflow if signs of operands was identical and result's sign was opposite.
            // >> 63 gives the sign bit (either 64 1's or 64 0's).
            if ((this._millis >>> 63 === ts._millis >> 63) && (this.Milliseconds >>> 63 !== result >> 63))
                throw new Error("Overflow_TimeSpanTooLong"); //OverflowException
            return new TimeSpan(result);
        }
        CompareTo(value) {
            if (!(value instanceof TimeSpan))
                throw new Error("Arg_MustBeTimeSpan"); //ArgumentException
            let m = value._millis;
            if (this._millis > m)
                return 1;
            if (this._millis < m)
                return -1;
            return 0;
        }
    }
    // non ticks use in js - public static     TicksPerMillisecond:number =  10000; //const
    // non ticks use in js - private static  MillisecondsPerTick:number = 1.0 / TimeSpan.TicksPerMillisecond; //const
    // non ticks use in js - public static  TicksPerSecond:number = TimeSpan.TicksPerMillisecond * 1000;   // 10,000,000 //const
    // non ticks use in js - private static  SecondsPerTick:number =  1.0 / TimeSpan.TicksPerSecond;         // 0.0001 //const
    // non ticks use in js - public static  TicksPerMinute:number = TimeSpan.TicksPerSecond * 60;         // 600,000,000 //const
    // non ticks use in js - private static  MinutesPerTick:number = 1.0 / TimeSpan.TicksPerMinute; // 1.6666666666667e-9 //const
    // non ticks use in js - public static  TicksPerHour:number = TimeSpan.TicksPerMinute * 60;        // 36,000,000,000 //const
    // non ticks use in js - private static  HoursPerTick:number = 1.0 / TimeSpan.TicksPerHour; // 2.77777777777777778e-11 //const
    // non ticks use in js - public static  TicksPerDay:number = TimeSpan.TicksPerHour * 24;          // 864,000,000,000 //const
    // non ticks use in js - private static  DaysPerTick:number = 1.0 / TimeSpan.TicksPerDay; // 1.1574074074074074074e-12 //const
    TimeSpan.MillisPerSecond = 1000; //const
    TimeSpan.MillisPerMinute = TimeSpan.MillisPerSecond * 60; //     60,000 //const
    TimeSpan.MillisPerHour = TimeSpan.MillisPerMinute * 60; //  3,600,000 //const
    TimeSpan.MillisPerDay = TimeSpan.MillisPerHour * 24; // 86,400,000 //const
    TimeSpan.MaxSeconds = Number.MAX_VALUE / TimeSpan.MillisPerSecond; // TimeSpan.TicksPerSecond; //const
    TimeSpan.MinSeconds = Number.MIN_VALUE / TimeSpan.MillisPerSecond; // TimeSpan.TicksPerSecond; //const
    TimeSpan.MaxMilliSeconds = Number.MAX_VALUE; /// TimeSpan.TicksPerMillisecond; //const
    TimeSpan.MinMilliSeconds = Number.MIN_VALUE; /// TimeSpan.TicksPerMillisecond; //const
    //private static  TicksPerTenthSecond:number = TimeSpan.TicksPerMillisecond * 100; //const
    TimeSpan.Zero = new TimeSpan(0); //readonly
    TimeSpan.MaxValueTimeSpan = new TimeSpan(Number.MAX_VALUE); //readonly
    TimeSpan.MinValueTimeSpan = new TimeSpan(Number.MIN_VALUE); //readonly
})(TimeSpan2 || (TimeSpan2 = {}));
//# sourceMappingURL=TimeSpan.js.map