"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyBasedFilter = void 0;
const PropertyDefinitionBase_1 = require("../../PropertyDefinitions/PropertyDefinitionBase");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const Strings_1 = require("../../Strings");
const SearchFilter_1 = require("./SearchFilter");
class PropertyBasedFilter extends SearchFilter_1.SearchFilter {
    constructor(propertyDefinition) {
        super();
        this.propertyDefinition = null;
        if (arguments.length === 1) {
            this.propertyDefinition = propertyDefinition;
        }
    }
    /**
     * Gets or sets the definition of the property that is involved in the search filter. Property definitions are available as static members from schema classes (for example, EmailMessageSchema.Subject, AppointmentSchema.Start, ContactSchema.GivenName, etc.)
     */
    get PropertyDefinition() {
        return this.propertyDefinition;
    }
    set PropertyDefinition(value) {
        this.SetFieldValue({ getValue: () => this.propertyDefinition, setValue: (updateValue) => { this.propertyDefinition = updateValue; } }, value);
    }
    /**
     * @internal Validate instance.
     */
    InternalValidate() {
        if (this.propertyDefinition == null) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.PropertyDefinitionPropertyMustBeSet);
        }
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        this.PropertyDefinition = PropertyDefinitionBase_1.PropertyDefinitionBase.LoadFromXmlJsObject(jsObject);
    }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) { this.PropertyDefinition.WriteToXml(writer); }
}
exports.PropertyBasedFilter = PropertyBasedFilter;
//# sourceMappingURL=SearchFilter.PropertyBasedFilter.js.map