"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeZonePropertyDefinition = void 0;
const TimeZoneDefinition_1 = require("../ComplexProperties/TimeZones/TimeZoneDefinition");
const EwsLogging_1 = require("../Core/EwsLogging");
const PropertyDefinition_1 = require("./PropertyDefinition");
/**
 * @internal Represents a property definition for properties of type TimeZoneInfo.
 */
class TimeZonePropertyDefinition extends PropertyDefinition_1.PropertyDefinition {
    /**
     * Gets the property type.
     */
    // Type: any;//System.Type;
    /**
     * @internal Initializes a new instance of the **TimeZonePropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Loads the property value from json.
     *
     * @param   {any}               jsObject         The JSON value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        EwsLogging_1.EwsLogging.DebugLog("[TimeZonePropertyDefinition.LoadPropertyValueFromXmlJsObject]: TimeZone info has been updated, Please report any bugs to github");
        let timeZoneDefinition = new TimeZoneDefinition_1.TimeZoneDefinition();
        if (jsObject) {
            timeZoneDefinition.LoadFromXmlJsObject(jsObject, service);
        }
        propertyBag._setItem(this, timeZoneDefinition.ToTimeZoneInfo(service));
    }
    /**
     * @internal Writes the property value to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        EwsLogging_1.EwsLogging.DebugLog("[TimeZonePropertyDefinition.WritePropertyValueToXml]: TimeZone info has been updated, Please report any bugs to github");
        let value = propertyBag._getItem(this);
        if (value != null) {
            // We emit time zone properties only if we have not emitted the time zone SOAP header
            // or if this time zone is different from that of the service through which the request
            // is being emitted.
            if (!writer.IsTimeZoneHeaderEmitted || value != writer.Service.TimeZone) {
                let timeZoneDefinition = new TimeZoneDefinition_1.TimeZoneDefinition(value);
                timeZoneDefinition.WriteToXml(writer, this.XmlElementName);
            }
        }
    }
}
exports.TimeZonePropertyDefinition = TimeZonePropertyDefinition;
//# sourceMappingURL=TimeZonePropertyDefinition.js.map