"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeSpanPropertyDefinition = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const GenericPropertyDefinition_1 = require("./GenericPropertyDefinition");
/**
 * @internal Represents TimeSpan property definition. based on moment Duration
 */
class TimeSpanPropertyDefinition extends GenericPropertyDefinition_1.GenericPropertyDefinition {
    /**
     * @internal Initializes a new instance of the **TimeSpanPropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version, false);
    }
    /**
     * @internal Parses the specified value (added to workaround Generic based value conversion in c#).
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        return EwsUtilities_1.EwsUtilities.XSDurationToTimeSpan(value);
    }
    /**
     * Convert instance to string.
     *
     * @param   {any}       value   The value.
     * @return  {string}    TimeSpan value.
     */
    ToString(value) {
        if (value)
            return EwsUtilities_1.EwsUtilities.TimeSpanToXSDuration(value);
        throw new Error("TimeSpanPropertyDefinition: incorrect call of ToString(value): value is undefined");
    }
}
exports.TimeSpanPropertyDefinition = TimeSpanPropertyDefinition;
//# sourceMappingURL=TimeSpanPropertyDefinition.js.map