"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskDelegationStatePropertyDefinition = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const ExtensionMethods_1 = require("../ExtensionMethods");
const TaskDelegationState_1 = require("../Enumerations/TaskDelegationState");
const GenericPropertyDefinition_1 = require("./GenericPropertyDefinition");
/**
 * @internal Represents a task delegation property definition.
 */
class TaskDelegationStatePropertyDefinition extends GenericPropertyDefinition_1.GenericPropertyDefinition {
    /**
     * @internal Initializes a new instance of the **TaskDelegationStatePropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version, false); //ref: not setting enumType as this.ToString Method covers for the string conversion
    }
    /**
     * @internal Parses the specified value (added to workaround Generic based value conversion in c#).
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        switch (value) {
            case TaskDelegationStatePropertyDefinition.NoMatch:
                return TaskDelegationState_1.TaskDelegationState.NoDelegation;
            case TaskDelegationStatePropertyDefinition.OwnNew:
                return TaskDelegationState_1.TaskDelegationState.Unknown;
            case TaskDelegationStatePropertyDefinition.Owned:
                return TaskDelegationState_1.TaskDelegationState.Accepted;
            case TaskDelegationStatePropertyDefinition.Accepted:
                return TaskDelegationState_1.TaskDelegationState.Declined;
            default:
                EwsLogging_1.EwsLogging.Assert(false, "TaskDelegationStatePropertyDefinition.Parse", ExtensionMethods_1.StringHelper.Format("TaskDelegationStatePropertyDefinition.Parse(): value {0} cannot be handled.", value));
                return null; // To keep the compiler happy
        }
    }
    /**
     * Convert instance to string.
     *
     * @param   {any}       value   The value.
     * @return  {string}    TaskDelegationState value.
     */
    ToString(value) {
        let taskDelegationState = value;
        switch (taskDelegationState) {
            case TaskDelegationState_1.TaskDelegationState.NoDelegation:
                return TaskDelegationStatePropertyDefinition.NoMatch;
            case TaskDelegationState_1.TaskDelegationState.Unknown:
                return TaskDelegationStatePropertyDefinition.OwnNew;
            case TaskDelegationState_1.TaskDelegationState.Accepted:
                return TaskDelegationStatePropertyDefinition.Owned;
            case TaskDelegationState_1.TaskDelegationState.Declined:
                return TaskDelegationStatePropertyDefinition.Accepted;
            default:
                EwsLogging_1.EwsLogging.Assert(false, "TaskDelegationStatePropertyDefinition.ToString", "Invalid TaskDelegationState value.");
                return null; // To keep the compiler happy
        }
    }
}
exports.TaskDelegationStatePropertyDefinition = TaskDelegationStatePropertyDefinition;
TaskDelegationStatePropertyDefinition.NoMatch = "NoMatch";
TaskDelegationStatePropertyDefinition.OwnNew = "OwnNew";
TaskDelegationStatePropertyDefinition.Owned = "Owned";
TaskDelegationStatePropertyDefinition.Accepted = "Accepted";
//# sourceMappingURL=TaskDelegationStatePropertyDefinition.js.map