"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyDefinitionBase = void 0;
const TypeContainer_1 = require("../TypeContainer");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
/**
 * Represents the base class for all property definitions.
 */
class PropertyDefinitionBase {
    /**
     * Gets the type of the property.
     */
    get Type() { return PropertyDefinitionBase; } //System.Type;
    /**
     * @internal Initializes a new instance of the **PropertyDefinitionBase** class.
     */
    constructor() { }
    ToString() { return this.GetPrintableName(); }
    //TryLoadFromJson(jsonObject: JsonObject): PropertyDefinitionBase{ throw new Error("PropertyDefinitionBase.ts - TryLoadFromJson : Not implemented.");}
    /**
     * @internal load from XMLJsObject.
     *
     * @param   {any}   jsonObject   The json object.
     * @return  {PropertyDefinitionBase}        True if property was loaded.
     */
    static LoadFromXmlJsObject(jsObject) {
        for (var key in jsObject) {
            if (key.indexOf("__") === 0) {
                continue;
            }
            switch (key) {
                case XmlElementNames_1.XmlElementNames.FieldURI:
                    return TypeContainer_1.TypeContainer.ServiceObjectSchema.FindPropertyDefinition(XmlAttributeNames_1.XmlAttributeNames.FieldURI);
                case XmlElementNames_1.XmlElementNames.IndexedFieldURI:
                    return new TypeContainer_1.TypeContainer.IndexedPropertyDefinition(jsObject[XmlAttributeNames_1.XmlAttributeNames.FieldURI], jsObject[XmlAttributeNames_1.XmlAttributeNames.FieldIndex]);
                case XmlElementNames_1.XmlElementNames.ExtendedFieldURI:
                    let propertyDefiniton = new TypeContainer_1.TypeContainer.ExtendedPropertyDefinition();
                    propertyDefiniton.LoadPropertyValueFromXmlJsObject(jsObject);
                    return propertyDefiniton;
                default:
                    break;
            }
        }
        return null;
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, this.GetXmlElementName());
        this.WriteAttributesToXml(writer);
        writer.WriteEndElement();
    }
}
exports.PropertyDefinitionBase = PropertyDefinitionBase;
//# sourceMappingURL=PropertyDefinitionBase.js.map