"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyDefinition = void 0;
const PropertyDefinitionFlags_1 = require("../Enumerations/PropertyDefinitionFlags");
const ExtensionMethods_1 = require("../ExtensionMethods");
const ServiceObjectPropertyDefinition_1 = require("./ServiceObjectPropertyDefinition");
/**
 * Represents the definition of a folder or item property.
 */
class PropertyDefinition extends ServiceObjectPropertyDefinition_1.ServiceObjectPropertyDefinition {
    constructor(propertyName, xmlElementName, uriOrFlags, versionOrFlags, version) {
        typeof uriOrFlags === 'string' ? super(uriOrFlags) : super();
        this.name = propertyName;
        this.xmlElementName = xmlElementName;
        this.flags = typeof uriOrFlags === 'string' ? PropertyDefinitionFlags_1.PropertyDefinitionFlags.None : uriOrFlags;
        switch (arguments.length) {
            case 4:
                this.version = versionOrFlags;
                break;
            case 5:
                this.version = version;
                this.flags = versionOrFlags;
                break;
            default:
                break;
        }
    }
    /**
     * @internal Gets a value indicating whether this property definition is for a nullable type (ref, int?, bool?...).
     */
    get IsNullable() { return true; }
    /**
     * Gets the name of the property.
     */
    get Name() {
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.name)) {
            throw new Error("PropertyDefinition.Name - incorrectly registered propertynames - info: fixed by initializing names in respective serviceobjectschema static properties. fix if receive this error");
            //todo:fix: can not use this to initialize names, ServiceObjectSchema creates circular loops in modules.
            //ServiceObjectSchema.InitializeSchemaPropertyNames(); //info: fixed by initializing names in respective serviceobjectschema static properties. fix if receive this error
            //fix - did not work , shifted to statically initialize by constructer in this class ServiceObjectSchemaExtension.InitializeSchemaPropertyNames(); //info: fixed by initializing names in respective serviceobjectschema static properties. fix if receive this error
        }
        return this.name;
    }
    set Name(value) { this.name = value; }
    /**
     * Gets the minimum Exchange version that supports this property.
     *
     * @value {ExchangeVersion} The version.
     */
    get Version() { return this.version; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @value {string}  The name of the XML element.
     */
    get XmlElementName() { return this.xmlElementName; }
    /**
     * @internal Gets a list of associated internal properties.
     *
     * /remarks/    This is a hack. It is here (currently) solely to help the API register the MeetingTimeZone property definition that is internal.
     * @return  {PropertyDefinition[]}      A list of PropertyDefinition objects.
     */
    GetAssociatedInternalProperties() {
        var properties = [];
        this.RegisterAssociatedInternalProperties(properties);
        return properties;
    }
    /**
     * @internal Gets the property definition's printable name.
     *
     * @return  {string}      The property definition's printable name.
     */
    GetPrintableName() { return this.Name; }
    HasFlag(flag, version) {
        return (this.flags & flag) == flag;
    }
    /**
     * @internal Registers associated internal properties.
     *
     * @param   {PropertyDefinition[]}   properties   The list in which to add the associated properties.
     */
    RegisterAssociatedInternalProperties(properties) {
    }
}
exports.PropertyDefinition = PropertyDefinition;
//# sourceMappingURL=PropertyDefinition.js.map