"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionSetPropertyDefinition = void 0;
const FolderPermissionCollection_1 = require("../ComplexProperties/FolderPermissionCollection");
const TypeContainer_1 = require("../TypeContainer");
const EwsLogging_1 = require("../Core/EwsLogging");
const ComplexPropertyDefinitionBase_1 = require("./ComplexPropertyDefinitionBase");
/**
 * @internal Represents permission set property definition.
 */
class PermissionSetPropertyDefinition extends ComplexPropertyDefinitionBase_1.ComplexPropertyDefinitionBase {
    /**
     * Gets the property type.
     */
    get Type() {
        return undefined; // new Type("FolderPermissionCollection");
    }
    /**
     * @internal Initializes a new instance of the **PermissionSetPropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Creates the property instance.
     *
     * @param   {ServiceObject}   owner   The owner.
     * @return  {ComplexProperty}       ComplexProperty.
     */
    CreatePropertyInstance(owner) {
        var folder = owner instanceof TypeContainer_1.TypeContainer.Folder ? owner : null;
        EwsLogging_1.EwsLogging.Assert(folder !== null, "PermissionCollectionPropertyDefinition.CreatePropertyInstance", "The owner parameter is not of type Folder or a derived class.");
        return new FolderPermissionCollection_1.FolderPermissionCollection(folder);
    }
}
exports.PermissionSetPropertyDefinition = PermissionSetPropertyDefinition;
//# sourceMappingURL=PermissionSetPropertyDefinition.js.map