"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntPropertyDefinition = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const GenericPropertyDefinition_1 = require("./GenericPropertyDefinition");
/**
 * @internal Represents Integer property defintion.
 */
class IntPropertyDefinition extends GenericPropertyDefinition_1.GenericPropertyDefinition {
    constructor(propertyName, xmlElementName, uri, versionOrFlags, version, isNullable) {
        switch (arguments.length) {
            case 4:
                super(propertyName, xmlElementName, uri, versionOrFlags);
                break;
            case 5:
                super(propertyName, xmlElementName, uri, versionOrFlags, version, false);
                break;
            case 6:
                super(propertyName, xmlElementName, uri, versionOrFlags, version, isNullable);
                break;
            default:
                break;
        }
    }
    /**
     * @internal Parses the specified value (added to workaround Generic based value conversion in c#).
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        return ExtensionMethods_1.Convert.toNumber(value);
    }
}
exports.IntPropertyDefinition = IntPropertyDefinition;
//# sourceMappingURL=IntPropertyDefinition.js.map