"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComplexPropertyDefinitionBase = void 0;
const PropertyDefinitionFlags_1 = require("../Enumerations/PropertyDefinitionFlags");
const PropertyDefinition_1 = require("./PropertyDefinition");
/**
 * @internal Represents abstract complex property definition.
 */
class ComplexPropertyDefinitionBase extends PropertyDefinition_1.PropertyDefinition {
    constructor(propertyName, xmlElementName, uriOrFlags, versionOrFlags, version) {
        switch (arguments.length) {
            case 4:
                super(propertyName, xmlElementName, uriOrFlags, versionOrFlags);
                break;
            case 5:
                super(propertyName, xmlElementName, uriOrFlags, versionOrFlags, version);
                break;
            default:
                break;
        }
    }
    /**
     * Gets the property instance.
     *
     * @param   {PropertyBag}       propertyBag       The property bag.
     * @param   {complexProperty}   complexProperty   The property instance.
     * @return  {boolean}    True if the instance is newly created.
     */
    GetPropertyInstance(propertyBag, complexProperty) {
        complexProperty.outValue = null;
        if (!propertyBag.TryGetValue(this, complexProperty) || !this.HasFlag(PropertyDefinitionFlags_1.PropertyDefinitionFlags.ReuseInstance, propertyBag.Owner.Service.RequestedServerVersion)) {
            complexProperty.outValue = this.CreatePropertyInstance(propertyBag.Owner);
            return true;
        }
        return false;
    }
    /**
     * @internal Internals the load from XMlJsObject.
     *
     * @param   {any}               jsObject    The json object.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    InternalLoadFromXmlJsObject(jsObject, service, propertyBag) {
        var outComplexproperty = { outValue: null };
        var justCreated = this.GetPropertyInstance(propertyBag, outComplexproperty);
        //assume collection type
        var complexPropertyCollection = outComplexproperty.outValue;
        //check for collection type //todo: implement better ComplexPropertyCollection detection
        if (complexPropertyCollection.Items) { //false if ths is not collection
            if (!justCreated && this.HasFlag(PropertyDefinitionFlags_1.PropertyDefinitionFlags.UpdateCollectionItems, propertyBag.Owner.Service.RequestedServerVersion)) {
                complexPropertyCollection.UpdateFromXmlJsObjectCollection(jsObject, service);
            }
            else {
                complexPropertyCollection.CreateFromXmlJsObjectCollection(jsObject, service);
            }
        }
        else {
            //var typename = TypeSystem.GetJsObjectTypeName(jsObject);
            outComplexproperty.outValue.LoadFromXmlJsObject(jsObject, service);
        }
        propertyBag._setItem(this, outComplexproperty.outValue);
    }
    /**
     * @internal Loads the property value from XMLJsObject.
     *
     * @param   {any}               jsObject         The JSON value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        // check for null value from empty element
        if (jsObject) {
            //debugger;//update: array type detection in next call, can not call GetPropertyInstance multiple time
            this.InternalLoadFromXmlJsObject(jsObject, service, propertyBag);
        }
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        var complexProperty = propertyBag._getItem(this);
        //debugger;
        if (complexProperty) {
            complexProperty.WriteToXml(writer, this.XmlElementName);
        }
    }
}
exports.ComplexPropertyDefinitionBase = ComplexPropertyDefinitionBase;
//# sourceMappingURL=ComplexPropertyDefinitionBase.js.map