"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComplexPropertyDefinition = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const TypeGuards_1 = require("../Interfaces/TypeGuards");
const ComplexPropertyDefinitionBase_1 = require("./ComplexPropertyDefinitionBase");
/**
 * @internal Represents base complex property type.
 *
 * @type <TComplexProperty> The type of the complex property.
 */
class ComplexPropertyDefinition extends ComplexPropertyDefinitionBase_1.ComplexPropertyDefinitionBase {
    constructor(propertyName, xmlElementName, uriOrFlags, versionOrFlags, versionOrDelegate, propertyCreationDelegate) {
        switch (arguments.length) {
            case 5:
                super(propertyName, xmlElementName, uriOrFlags, versionOrFlags);
                this.propertyCreationDelegate = versionOrDelegate;
                EwsLogging_1.EwsLogging.Assert(this.propertyCreationDelegate != null, "ComplexPropertyDefinition ctor", "CreateComplexPropertyDelegate cannot be null");
                break;
            case 6:
                super(propertyName, xmlElementName, uriOrFlags, versionOrFlags, versionOrDelegate);
                this.propertyCreationDelegate = propertyCreationDelegate;
                break;
            default:
                break;
        }
    }
    /**
     * @internal Creates the property instance.
     *
     * @param   {ServiceObject}   owner   The owner.
     * @return  {ComplexProperty}       ComplexProperty instance.
     */
    CreatePropertyInstance(owner) {
        var complexProperty = this.propertyCreationDelegate();
        if (TypeGuards_1.TypeGuards.isIOwnedProperty(complexProperty)) { //IOwnedProperty ownedProperty = complexProperty as IOwnedProperty;
            complexProperty.Owner = owner;
        }
        if (complexProperty)
            return complexProperty;
    }
}
exports.ComplexPropertyDefinition = ComplexPropertyDefinition;
//# sourceMappingURL=ComplexPropertyDefinition.js.map