"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionBase = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents the base class for event subscriptions.
 */
class SubscriptionBase {
    constructor(service, id = null, watermark = null) {
        this.service = null;
        this.id = null;
        this.watermark = null;
        EwsUtilities_1.EwsUtilities.ValidateParam(service, "service");
        this.service = service;
        if (arguments.length >= 2) {
            EwsUtilities_1.EwsUtilities.ValidateParam(id, "id");
        }
        this.id = id;
        this.watermark = watermark;
    }
    /**
     * Gets the session.
     *
     * @value The session.
     */
    get Service() {
        return this.service;
    }
    /**
     * Gets the Id of the subscription.
     *
     * internal set
     */
    get Id() {
        return this.id;
    }
    set Id(value) {
        this.id = value;
    }
    /**
     * Gets the latest watermark of the subscription. Watermark is always null for streaming subscriptions.
     *
     * internal set
     */
    get Watermark() {
        return this.watermark;
    }
    set Watermark(value) {
        this.watermark = value;
    }
    /**
     * Gets whether or not this subscription uses watermarks.
     */
    get UsesWatermark() {
        return true;
    }
    /**
     * @internal Loads from XML.
     *
     * @param   {any}                 jsObject               Json Object converted from XML.
     * @param   {ExchangeService}     service                The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        this.id = jsObject[XmlElementNames_1.XmlElementNames.SubscriptionId];
        if (this.UsesWatermark) {
            this.watermark = jsObject[XmlElementNames_1.XmlElementNames.Watermark];
        }
    }
}
exports.SubscriptionBase = SubscriptionBase;
//# sourceMappingURL=SubscriptionBase.js.map