"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullSubscription = void 0;
const SubscriptionBase_1 = require("./SubscriptionBase");
/**
 * Represents a pull subscription.
 *
 * @sealed
 */
class PullSubscription extends SubscriptionBase_1.SubscriptionBase {
    /**
     * @internal Initializes a new instance of the **PullSubscription** class.
     *
     * @param   {ExchangeService}   service     The service.
     */
    constructor(service) {
        super(service);
        this.moreEventsAvailable = null;
    }
    /**
     * Gets a value indicating whether more events are available on the server.
     * MoreEventsAvailable is undefined (null) until GetEvents is called.
     */
    get MoreEventsAvailable() {
        return this.moreEventsAvailable;
    }
    /**
     * Obtains a collection of events that occurred on the subscribed folders since the point in time defined by the Watermark property. When GetEvents succeeds, Watermark is updated.
     *
     * @return  {Promise<GetEventsResults>}      Returns a collection of events that occurred since the last watermark	:Promise.
     */
    GetEvents() {
        return this.Service.GetEvents(this.Id, this.Watermark).then((results) => {
            this.Watermark = results.NewWatermark;
            this.moreEventsAvailable = results.MoreEventsAvailable;
            return results;
        });
    }
    /**
     * Unsubscribes from the pull subscription.
     */
    Unsubscribe() { return this.Service.Unsubscribe(this.Id); }
}
exports.PullSubscription = PullSubscription;
//# sourceMappingURL=PullSubscription.js.map