"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationEvent = void 0;
const EventType_1 = require("../Enumerations/EventType");
/**
 * Represents an event as exposed by push and pull notifications.
 */
class NotificationEvent {
    /**
     * @internal Initializes a new instance of the **NotificationEvent** class.
     *
     * @param   {EventType}		eventType   Type of the event.
     * @param   {DateTime}   	timestamp   The event timestamp.
     */
    constructor(eventType, timestamp) {
        /**
         * Type of this event.
         */
        this.eventType = EventType_1.EventType.Status;
        /**
         * Date and time when the event occurred.
         */
        this.timestamp = null;
        /**
         * Id of parent folder of the item or folder this event applies to.
         */
        this.parentFolderId = null;
        /**
         * Id of the old prarent foldero of the item or folder this event applies to.
         * This property is only meaningful when EventType is equal to either EventType.Moved or EventType.Copied.
         * For all other event types, oldParentFolderId will be null.
         */
        this.oldParentFolderId = null;
        this.eventType = eventType;
        this.timestamp = timestamp;
    }
    /**
     * Gets the type of this event.
     */
    get EventType() {
        return this.eventType;
    }
    /**
     * Gets the date and time when the event occurred.
     */
    get TimeStamp() {
        return this.timestamp;
    }
    /**
     * Gets the Id of the parent folder of the item or folder this event applie to.
     */
    get ParentFolderId() {
        return this.parentFolderId;
    }
    set ParentFolderId(value) {
        this.parentFolderId = value;
    }
    /**
     * Gets the Id of the old parent folder of the item or folder this event applies to.
     * OldParentFolderId is only meaningful when EventType is equal to either EventType.Moved or EventType.Copied.
     * For all other event types, OldParentFolderId is null.
     */
    get OldParentFolderId() {
        return this.oldParentFolderId;
    }
    set OldParentFolderId(value) {
        this.oldParentFolderId = value;
    }
}
exports.NotificationEvent = NotificationEvent;
//# sourceMappingURL=NotificationEvent.js.map