"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemWrapper = void 0;
const AbstractItemIdWrapper_1 = require("./AbstractItemIdWrapper");
const EwsLogging_1 = require("../Core/EwsLogging");
class ItemWrapper extends AbstractItemIdWrapper_1.AbstractItemIdWrapper {
    constructor(item) {
        super();
        EwsLogging_1.EwsLogging.Assert(item != null, "ItemWrapper.ctor", "item is null");
        EwsLogging_1.EwsLogging.Assert(!item.IsNew, "ItemWrapper.ctor", "item does not have an Id");
        this.item = item;
    }
    GetItem() { return this.item; }
    IternalToJson(service) { throw new Error("ItemWrapper.ts - IternalToJson : Not implemented."); }
    /**@internal */
    WriteToXml(writer) { this.item.Id.WriteToXml(writer); }
}
exports.ItemWrapper = ItemWrapper;
//# sourceMappingURL=ItemWrapper.js.map