"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternatePublicFolderId = void 0;
const IdFormat_1 = require("../../Enumerations/IdFormat");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const AlternateIdBase_1 = require("./AlternateIdBase");
/**
 * Represents the Id of a public folder expressed in a specific format.
 */
class AlternatePublicFolderId extends AlternateIdBase_1.AlternateIdBase {
    constructor(format = IdFormat_1.IdFormat.EwsLegacyId, folderId = null) {
        super(format);
        /**
         * The Id of the public folder.
         */
        this.FolderId = null;
        this.FolderId = folderId;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.AlternatePublicFolderId;
    }
    /**
     * @internal Loads the attributes from Xml JsObject.
     *
     * @param   {any}   responseObject   The response object.
     */
    LoadAttributesFromXmlJsObject(responseObject) {
        super.LoadAttributesFromXmlJsObject(responseObject);
        this.FolderId = responseObject[XmlAttributeNames_1.XmlAttributeNames.FolderId];
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FolderId, this.FolderId);
    }
}
exports.AlternatePublicFolderId = AlternatePublicFolderId;
/**
 * @internal Name of schema type used for AlternatePublicFolderId element.
 */
AlternatePublicFolderId.SchemaTypeName = "AlternatePublicFolderIdType";
//# sourceMappingURL=AlternatePublicFolderId.js.map