"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegateInformation = void 0;
const MeetingRequestsDeliveryScope_1 = require("../Enumerations/MeetingRequestsDeliveryScope");
/**
 * Represents the results of a GetDelegates operation.
 *
 * @sealed
 */
class DelegateInformation {
    /**
     * @internal Initializes a **DelegateInformation** object
     *
     * @param   {DelegateUserResponse[]}   		delegateUserResponses         List of DelegateUserResponses from a GetDelegates request
     * @param   {MeetingRequestsDeliveryScope}	meetingReqestsDeliveryScope   MeetingRequestsDeliveryScope from a GetDelegates request.
     */
    constructor(delegateUserResponses, meetingReqestsDeliveryScope) {
        this.meetingReqestsDeliveryScope = MeetingRequestsDeliveryScope_1.MeetingRequestsDeliveryScope.DelegatesOnly;
        this.delegateUserResponses = delegateUserResponses || [];
        this.meetingReqestsDeliveryScope = meetingReqestsDeliveryScope;
    }
    /**
     * Gets a list of responses for each of the delegate users concerned by the operation.
     */
    get DelegateUserResponses() {
        return this.delegateUserResponses;
    }
    /**
     * Gets a value indicating if and how meeting requests are delivered to delegates.
     */
    get MeetingRequestsDeliveryScope() {
        return this.meetingReqestsDeliveryScope;
    }
}
exports.DelegateInformation = DelegateInformation;
//# sourceMappingURL=DelegateInformation.js.map