"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OofReply = void 0;
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
/**
 * Represents an Out of Office response.
 */
class OofReply {
    constructor(message = null) {
        this.culture = ''; //todo: implement CultureInfo //  CultureInfo.CurrentCulture.Name;
        this.message = null;
        this.message = message;
    }
    /**
     * Gets or sets the culture of the reply.
     */
    get Culture() {
        return this.culture;
    }
    set Culture(value) {
        this.culture = value;
    }
    /**
     * Gets or sets the culture of the reply.
     */
    get Message() {
        return this.message;
    }
    set Message(value) {
        this.message = value;
    }
    /**
     * @internal Loads from xmlJsObject.
     *
     * @param   {any}   jsObject   The xmlJsObject object.
     * @param   {ExchangeService}   service      The service.
     */
    LoadFromXmlJsObject(jsonObject, service) {
        if (jsonObject["xml:lang"]) {
            this.culture = jsonObject["xml:lang"];
        }
        this.message = jsonObject[XmlElementNames_1.XmlElementNames.Message];
    }
    /**
     * Obtains a string representation of the reply.
     *
     * @return  {string}      A string containing the reply message.
     */
    ToString() { return this.Message; }
    toString() { return this.Message; }
    /**
     * @internal Writes an empty OofReply to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer           The writer.
     * @param   {string}                xmlElementName   Name of the XML element.
     */
    static WriteEmptyReplyToXml(writer, xmlElementName) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, xmlElementName);
        writer.WriteEndElement(); // xmlElementName
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer           The writer.
     * @param   {string}                xmlElementName   Name of the XML element.
     */
    WriteToXml(writer, xmlElementName) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, xmlElementName);
        if (this.Culture != null) {
            writer.WriteAttributeValue("xml", "lang", this.Culture);
        }
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Message, this.Message);
        writer.WriteEndElement(); // xmlElementName
    }
}
exports.OofReply = OofReply;
//# sourceMappingURL=OofReply.js.map