"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvailabilityOptions = void 0;
const FreeBusyViewType_1 = require("../../Enumerations/FreeBusyViewType");
const SuggestionQuality_1 = require("../../Enumerations/SuggestionQuality");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const Strings_1 = require("../../Strings");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const TimeSpan_1 = require("../../TimeSpan");
class AvailabilityOptions {
    constructor() {
        this.mergedFreeBusyInterval = 30;
        this.requestedFreeBusyView = FreeBusyViewType_1.FreeBusyViewType.Detailed;
        this.goodSuggestionThreshold = 25;
        this.maximumSuggestionsPerDay = 10;
        this.maximumNonWorkHoursSuggestionsPerDay = 0;
        this.meetingDuration = 60;
        this.minimumSuggestionQuality = SuggestionQuality_1.SuggestionQuality.Fair;
        this.detailedSuggestionsWindow = null;
        this.currentMeetingTime = null;
        this.globalObjectId = null;
    }
    get MergedFreeBusyInterval() {
        return this.mergedFreeBusyInterval;
    }
    set MergedFreeBusyInterval(value) {
        if (value < 5 || value > 1440) {
            throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.InvalidPropertyValueNotInRange, "MergedFreeBusyInterval", 5, 1440)); //ArgumentException
        }
        this.mergedFreeBusyInterval = value;
    }
    get RequestedFreeBusyView() {
        return this.requestedFreeBusyView;
    }
    set RequestedFreeBusyView(value) {
        this.requestedFreeBusyView = value;
    }
    get GoodSuggestionThreshold() {
        return this.goodSuggestionThreshold;
    }
    set GoodSuggestionThreshold(value) {
        if (value < 1 || value > 49) {
            throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.InvalidPropertyValueNotInRange, "GoodSuggestionThreshold", 1, 49)); //ArgumentException
        }
        this.goodSuggestionThreshold = value;
    }
    get MaximumSuggestionsPerDay() {
        return this.maximumSuggestionsPerDay;
    }
    set MaximumSuggestionsPerDay(value) {
        if (value < 0 || value > 48) {
            throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.InvalidPropertyValueNotInRange, "MaximumSuggestionsPerDay", 0, 48)); //ArgumentException
        }
        this.maximumSuggestionsPerDay = value;
    }
    get MaximumNonWorkHoursSuggestionsPerDay() {
        return this.maximumNonWorkHoursSuggestionsPerDay;
    }
    set MaximumNonWorkHoursSuggestionsPerDay(value) {
        if (value < 0 || value > 48) {
            throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.InvalidPropertyValueNotInRange, "MaximumNonWorkHoursSuggestionsPerDay", 0, 48)); //ArgumentException
        }
        this.maximumNonWorkHoursSuggestionsPerDay = value;
    }
    get MeetingDuration() {
        return this.meetingDuration;
    }
    set MeetingDuration(value) {
        if (value < 30 || value > 1440) {
            throw new Error(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.InvalidPropertyValueNotInRange, "MeetingDuration", 30, 1440)); //ArgumentException
        }
        this.meetingDuration = value;
    }
    get MinimumSuggestionQuality() {
        return this.minimumSuggestionQuality;
    }
    set MinimumSuggestionQuality(value) {
        this.minimumSuggestionQuality = value;
    }
    get DetailedSuggestionsWindow() {
        return this.detailedSuggestionsWindow;
    }
    set DetailedSuggestionsWindow(value) {
        this.detailedSuggestionsWindow = value;
    }
    get CurrentMeetingTime() {
        return this.currentMeetingTime;
    }
    set CurrentMeetingTime(value) {
        this.currentMeetingTime = value;
    }
    get GlobalObjectId() {
        return this.globalObjectId;
    }
    set GlobalObjectId(value) {
        this.globalObjectId = value;
    }
    Validate(timeWindow) {
        if (TimeSpan_1.TimeSpan.FromMinutes(this.MergedFreeBusyInterval) > timeWindow) {
            throw new Error(Strings_1.Strings.MergedFreeBusyIntervalMustBeSmallerThanTimeWindow); //, "MergedFreeBusyInterval");//ArgumentException
        }
        EwsUtilities_1.EwsUtilities.ValidateParamAllowNull(this.DetailedSuggestionsWindow, "DetailedSuggestionsWindow");
    }
    /** @internal */
    WriteToXml(writer, request) {
        if (request.IsFreeBusyViewRequested) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.FreeBusyViewOptions);
            request.TimeWindow.WriteToXmlUnscopedDatesOnly(writer, XmlElementNames_1.XmlElementNames.TimeWindow);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MergedFreeBusyIntervalInMinutes, this.MergedFreeBusyInterval);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.RequestedView, FreeBusyViewType_1.FreeBusyViewType[this.RequestedFreeBusyView]);
            writer.WriteEndElement(); // FreeBusyViewOptions
        }
        if (request.IsSuggestionsViewRequested) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.SuggestionsViewOptions);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.GoodThreshold, this.GoodSuggestionThreshold);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MaximumResultsByDay, this.MaximumSuggestionsPerDay);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MaximumNonWorkHourResultsByDay, this.MaximumNonWorkHoursSuggestionsPerDay);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MeetingDurationInMinutes, this.MeetingDuration);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MinimumSuggestionQuality, SuggestionQuality_1.SuggestionQuality[this.MinimumSuggestionQuality]);
            var timeWindowToSerialize = this.DetailedSuggestionsWindow === null ?
                request.TimeWindow :
                this.DetailedSuggestionsWindow;
            timeWindowToSerialize.WriteToXmlUnscopedDatesOnly(writer, XmlElementNames_1.XmlElementNames.DetailedSuggestionsWindow);
            if (this.CurrentMeetingTime !== null) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.CurrentMeetingTime, this.CurrentMeetingTime);
            }
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.GlobalObjectId, this.GlobalObjectId);
            writer.WriteEndElement(); // SuggestionsViewOptions
        }
    }
}
exports.AvailabilityOptions = AvailabilityOptions;
//# sourceMappingURL=AvailabilityOptions.js.map