"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailboxQuery = void 0;
/**
 * Represents mailbox query object.
 *
 * @sealed
 */
class MailboxQuery {
    /**
     * Constructor
     *
     * @param   {string}                query          Search query
     * @param   {MailboxSearchScope[]}  searchScopes   Set of mailbox and scope pair
     */
    constructor(query, searchScopes) {
        /**
         * Search query
         */
        this.Query = null;
        /**
         * Set of mailbox and scope pair
         */
        this.MailboxSearchScopes = null;
        this.Query = query;
        this.MailboxSearchScopes = searchScopes;
    }
}
exports.MailboxQuery = MailboxQuery;
//# sourceMappingURL=MailboxQuery.js.map