"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailboxHoldResult = void 0;
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const HoldStatus_1 = require("../Enumerations/HoldStatus");
const MailboxHoldStatus_1 = require("./MailboxHoldStatus");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents mailbox hold result
 *
 * @sealed
 */
class MailboxHoldResult {
    constructor() {
        /**
         * Hold id
         */
        this.HoldId = null;
        /**
         * Query
         */
        this.Query = null;
        /**
         * Collection of mailbox status
         */
        this.Statuses = null;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     * @return  {MailboxHoldResult}              Mailbox hold object
     */
    static LoadFromXmlJsObject(jsObject, service) {
        let statuses = [];
        let holdResult = new MailboxHoldResult();
        if (jsObject[XmlElementNames_1.XmlElementNames.HoldId]) {
            holdResult.HoldId = jsObject[XmlElementNames_1.XmlElementNames.HoldId];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.Query]) {
            holdResult.Query = jsObject[XmlElementNames_1.XmlElementNames.Query];
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.MailboxHoldStatuses]) {
            for (let statusObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.MailboxHoldStatuses], XmlElementNames_1.XmlElementNames.MailboxHoldStatus)) {
                let status = new MailboxHoldStatus_1.MailboxHoldStatus();
                if (statusObject[XmlElementNames_1.XmlElementNames.Mailbox]) {
                    status.Mailbox = statusObject[XmlElementNames_1.XmlElementNames.Mailbox];
                }
                if (statusObject[XmlElementNames_1.XmlElementNames.Status]) {
                    status.Status = HoldStatus_1.HoldStatus[statusObject[XmlElementNames_1.XmlElementNames.Status]];
                }
                if (statusObject[XmlElementNames_1.XmlElementNames.AdditionalInfo]) {
                    status.AdditionalInfo = statusObject[XmlElementNames_1.XmlElementNames.AdditionalInfo];
                }
                statuses.push(status);
            }
        }
        holdResult.Statuses = statuses.length == 0 ? null : statuses;
        return holdResult;
    }
}
exports.MailboxHoldResult = MailboxHoldResult;
//# sourceMappingURL=MailboxHoldResult.js.map