"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FailedSearchMailbox = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EwsServiceJsonReader_1 = require("../Core/EwsServiceJsonReader");
const XmlElementNames_1 = require("../Core/XmlElementNames");
/**
 * Represents failed mailbox to be searched
 *
 * @sealed
 */
class FailedSearchMailbox {
    constructor(mailbox, errorCode, errorMessage, isArchive = false) {
        this.Mailbox = null;
        this.ErrorCode = 0;
        this.ErrorMessage = null;
        this.IsArchive = false;
        this.Mailbox = mailbox;
        this.ErrorCode = errorCode;
        this.ErrorMessage = errorMessage;
        this.IsArchive = isArchive;
    }
    /**
     * @internal Load failed mailboxes xml
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     * @return  {FailedSearchMailbox[]}       Failed search mailboxes.
     */
    static LoadFromXmlJsObject(jsObject, service) {
        let failedMailboxes = [];
        for (let failedMailboxObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject, XmlElementNames_1.XmlElementNames.FailedMailbox)) {
            let mailbox = null, errorCode = 0, errorMessage = null, isArchive = false;
            if (failedMailboxObject[XmlElementNames_1.XmlElementNames.Mailbox]) {
                mailbox = failedMailboxObject[XmlElementNames_1.XmlElementNames.Mailbox];
            }
            if (failedMailboxObject[XmlElementNames_1.XmlElementNames.ErrorCode]) {
                errorCode = ExtensionMethods_1.Convert.toNumber(failedMailboxObject[XmlElementNames_1.XmlElementNames.ErrorCode]);
            }
            if (failedMailboxObject[XmlElementNames_1.XmlElementNames.ErrorMessage]) {
                errorMessage = failedMailboxObject[XmlElementNames_1.XmlElementNames.ErrorMessage];
            }
            if (failedMailboxObject[XmlElementNames_1.XmlElementNames.IsArchive]) {
                isArchive = ExtensionMethods_1.Convert.toBool(failedMailboxObject[XmlElementNames_1.XmlElementNames.IsArchive]);
            }
            failedMailboxes.push(new FailedSearchMailbox(mailbox, errorCode, errorMessage, isArchive));
        }
        return failedMailboxes.length === 0 ? null : failedMailboxes;
    }
}
exports.FailedSearchMailbox = FailedSearchMailbox;
//# sourceMappingURL=FailedSearchMailbox.js.map