"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchServiceResponseException = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const ServiceRemoteException_1 = require("./ServiceRemoteException");
/**
 * Represents a remote service exception that can have multiple service responses.
 *
 * @type {TResponse}       The type of the response.
 */
class BatchServiceResponseException extends ServiceRemoteException_1.ServiceRemoteException {
    constructor(serviceResponses, message, innerException) {
        if (arguments.length == 2) {
            super(message);
        }
        else {
            super(message, innerException);
        }
        EwsLogging_1.EwsLogging.Assert(serviceResponses != null, "BatchServiceResponseException.ctor", "serviceResponses is null");
        this.responses = serviceResponses;
    }
    /**
     * Gets a list of responses returned by the web method.
     */
    get ServiceResponses() { return this.ServiceResponses; }
}
exports.BatchServiceResponseException = BatchServiceResponseException;
//# sourceMappingURL=BatchServiceResponseException.js.map