"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutodiscoverResponseException = void 0;
const ServiceRemoteException_1 = require("./ServiceRemoteException");
/**
 * Represents an exception from an autodiscover error response.
 *
 * @extends {ServiceRemoteException}
 */
class AutodiscoverResponseException extends ServiceRemoteException_1.ServiceRemoteException {
    /**
     * @internal Initializes a new instance of the **AutodiscoverResponseException** class.
     *
     * @param   {AutodiscoverErrorCode} errorCode   The error code.
     * @param   {string}                message     The message.
     */
    constructor(errorCode, message) {
        super(message);
        this.errorCode = errorCode;
    }
    /**
     * Gets the ErrorCode for the exception.
     */
    get ErrorCode() {
        return this.errorCode;
    }
}
exports.AutodiscoverResponseException = AutodiscoverResponseException;
//# sourceMappingURL=AutodiscoverResponseException.js.map