"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArgumentOutOfRangeException = exports.ArgumentNullException = exports.ArgumentException = void 0;
const Exception_1 = require("./Exception");
class ArgumentException extends Exception_1.Exception {
    constructor(message = null, paramNameOrInnerException = null, innerException = null) {
        super(message, innerException || (paramNameOrInnerException instanceof Exception_1.Exception ? paramNameOrInnerException : null));
        this.ParamName = null;
        if (typeof paramNameOrInnerException === 'string') {
            this.ParamName = message;
        }
    }
}
exports.ArgumentException = ArgumentException;
class ArgumentNullException extends ArgumentException {
    constructor(paramNameOrMessage = null, paramNameOrInnerException = null, innerException = null) {
        var argsLength = arguments.length;
        switch (argsLength) {
            case 1:
                super("Argument is Null", paramNameOrMessage);
                break;
            case 2:
                if (typeof paramNameOrInnerException === 'string') {
                    super(paramNameOrInnerException, paramNameOrMessage);
                }
                else {
                    super(paramNameOrMessage, paramNameOrInnerException);
                }
                break;
            default:
                super("Argument is Null");
                break;
        }
    }
}
exports.ArgumentNullException = ArgumentNullException;
class ArgumentOutOfRangeException extends ArgumentException {
    constructor(paramNameOrMessage, messageOrActualValueOrException, message = null) {
        //super((message || messageOrObjValueOrException instanceof Exception ? paramNameOrMessage : null);
        var argsLength = arguments.length;
        switch (argsLength) {
            case 0:
                super("ArgumentOutOfRangeException");
                break;
            case 1:
                super("ArgumentOutOfRangeException", paramNameOrMessage);
                break;
            case 2:
                if (typeof messageOrActualValueOrException === 'string') {
                    super(messageOrActualValueOrException, paramNameOrMessage);
                }
                else {
                    super(paramNameOrMessage, messageOrActualValueOrException);
                }
                break;
            case 3:
                super(message, paramNameOrMessage);
                this.actualValue = messageOrActualValueOrException;
                break;
            default:
                super("ArgumentOutOfRangeException");
                break;
        }
    }
    /**
     * Gets the value of the argument that caused the exception.
     */
    get ActualValue() { return this.actualValue; }
}
exports.ArgumentOutOfRangeException = ArgumentOutOfRangeException;
//# sourceMappingURL=ArgumentException.js.map