"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountIsLockedException = void 0;
const ServiceRemoteException_1 = require("./ServiceRemoteException");
/**
 * Represents an error that occurs when the account that is being accessed is locked and requires user interaction to be unlocked.
 */
class AccountIsLockedException extends ServiceRemoteException_1.ServiceRemoteException {
    /**
     * Initializes a new instance of the **AccountIsLockedException** class.
     *
     * @param   {string}        message            Error message text.
     * @param   {Uri}           accountUnlockUrl   URL for client to visit to unlock account.
     * @param   {Exception}     innerException     Inner exception.
     */
    constructor(message, accountUnlockUrl, innerException) {
        super(message, innerException);
        /**
         * Gets the URL of a web page where the user can navigate to unlock his or her account.
         *
         * internal set
         */
        this.AccountUnlockUrl = null;
        this.AccountUnlockUrl = accountUnlockUrl;
    }
}
exports.AccountIsLockedException = AccountIsLockedException;
//# sourceMappingURL=AccountIsLockedException.js.map