"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExchangeVersion = void 0;
/**
 * Defines the each available Exchange release version
 */
var ExchangeVersion;
(function (ExchangeVersion) {
    /**
     * Microsoft Exchange 2007, Service Pack 1
     */
    ExchangeVersion[ExchangeVersion["Exchange2007_SP1"] = 0] = "Exchange2007_SP1";
    /**
     * Microsoft Exchange 2010
     */
    ExchangeVersion[ExchangeVersion["Exchange2010"] = 1] = "Exchange2010";
    /**
     * Microsoft Exchange 2010, Service Pack 1
     */
    ExchangeVersion[ExchangeVersion["Exchange2010_SP1"] = 2] = "Exchange2010_SP1";
    /**
     * Microsoft Exchange 2010, Service Pack 2
     */
    ExchangeVersion[ExchangeVersion["Exchange2010_SP2"] = 3] = "Exchange2010_SP2";
    /**
     * Microsoft Exchange 2013
     */
    ExchangeVersion[ExchangeVersion["Exchange2013"] = 4] = "Exchange2013";
    /**
     * Microsoft Exchange 2013 SP1
     */
    ExchangeVersion[ExchangeVersion["Exchange2013_SP1"] = 5] = "Exchange2013_SP1";
    /**
     * Microsoft Exchange 2015 (aka Exchange 2016)
     */
    ExchangeVersion[ExchangeVersion["Exchange2015"] = 6] = "Exchange2015";
    /**
     * Microsoft Exchange 2016
     */
    ExchangeVersion[ExchangeVersion["Exchange2016"] = 7] = "Exchange2016";
    /**
     * Functionality starting 10/05/2015
     */
    ExchangeVersion[ExchangeVersion["V2015_10_05"] = 8] = "V2015_10_05";
    /**
     * Updated from latest Types.xsd in 03/2023
     */
    /**
     * Functionality starting 01/06/2016
     */
    ExchangeVersion[ExchangeVersion["V2016_01_06"] = 9] = "V2016_01_06";
    /**
     * Functionality starting 04/13/2016
     */
    ExchangeVersion[ExchangeVersion["V2016_04_13"] = 10] = "V2016_04_13";
    /**
     * Functionality starting 07/13/2016
     */
    ExchangeVersion[ExchangeVersion["V2016_07_13"] = 11] = "V2016_07_13";
    /**
     * Functionality starting 10/10/2016
     */
    ExchangeVersion[ExchangeVersion["V2016_10_10"] = 12] = "V2016_10_10";
    /**
     * Functionality starting 01/07/2017
     */
    ExchangeVersion[ExchangeVersion["V2017_01_07"] = 13] = "V2017_01_07";
    /**
     * Functionality starting 04/14/2017
     */
    ExchangeVersion[ExchangeVersion["V2017_04_14"] = 14] = "V2017_04_14";
    /**
     * Functionality starting 07/11/2017
     */
    ExchangeVersion[ExchangeVersion["V2017_07_11"] = 15] = "V2017_07_11";
    /**
     * Functionality starting 10/09/2017
     */
    ExchangeVersion[ExchangeVersion["V2017_10_09"] = 16] = "V2017_10_09";
    /**
     * Functionality starting 01/08/2018
     */
    ExchangeVersion[ExchangeVersion["V2018_01_08"] = 17] = "V2018_01_08";
    /** internal tracking of any version not updated in **ews-javascript-api** */
    ExchangeVersion[ExchangeVersion["Exchange_Version_Not_Updated"] = 15000] = "Exchange_Version_Not_Updated";
})(ExchangeVersion = exports.ExchangeVersion || (exports.ExchangeVersion = {}));
//# sourceMappingURL=ExchangeVersion.js.map