"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthCredentials = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const Strings_1 = require("../Strings");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ExchangeCredentials_1 = require("./ExchangeCredentials");
class OAuthCredentials extends ExchangeCredentials_1.ExchangeCredentials {
    constructor(token, verbatim = false) {
        super();
        this.token = null;
        this.credentials = null; /*System.Net.ICredentials*/
        EwsUtilities_1.EwsUtilities.ValidateParam(token, "token");
        var rawToken;
        if (verbatim) {
            rawToken = token;
        }
        else {
            var whiteSpacePosition = token.indexOf(' ');
            if (whiteSpacePosition == -1) {
                rawToken = token;
            }
            else {
                var authType = token.substring(0, whiteSpacePosition);
                if (ExtensionMethods_1.StringHelper.Compare(authType, OAuthCredentials.BearerAuthenticationType, true) != 0) {
                    throw new Error(Strings_1.Strings.InvalidAuthScheme); //ArgumentException
                }
                rawToken = token.substring(whiteSpacePosition + 1);
            }
            if (!OAuthCredentials.validTokenPattern.test(rawToken)) {
                throw new Error(Strings_1.Strings.InvalidOAuthToken); //ArgumentException
            }
        }
        this.token = OAuthCredentials.BearerAuthenticationType + " " + rawToken;
    }
    PrepareWebRequest(request /*IEwsHttpWebRequest*/) {
        request.headers["Authorization"] = this.token;
    }
}
exports.OAuthCredentials = OAuthCredentials;
OAuthCredentials.BearerAuthenticationType = "Bearer";
OAuthCredentials.validTokenPattern = new RegExp("^[A-Za-z0-9-_]+\\.[A-Za-z0-9-_]+\\.[A-Za-z0-9-_]*$");
//# sourceMappingURL=OAuthCredentials.js.map