"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseMessageSchema = void 0;
const Schemas_1 = require("./Schemas");
const ServiceObjectSchema_1 = require("./ServiceObjectSchema");
/**
 * Represents ResponseMessage schema definition.
 */
class ResponseMessageSchema extends ServiceObjectSchema_1.ServiceObjectSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.ItemSchema.Subject);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.ItemSchema.Body);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.EmailMessageSchema.ToRecipients);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.EmailMessageSchema.CcRecipients);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.EmailMessageSchema.BccRecipients);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.EmailMessageSchema.IsReadReceiptRequested);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.EmailMessageSchema.IsDeliveryReceiptRequested);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.ResponseObjectSchema.ReferenceItemId);
        this.RegisterProperty(ResponseMessageSchema, Schemas_1.Schemas.ResponseObjectSchema.BodyPrefix);
    }
}
exports.ResponseMessageSchema = ResponseMessageSchema;
/**
 * @internal Instance of **ResponseMessageSchema**
 */
ResponseMessageSchema.Instance = new ResponseMessageSchema();
//# sourceMappingURL=ResponseMessageSchema.js.map