"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostItemSchema = void 0;
const DateTimePropertyDefinition_1 = require("../../../PropertyDefinitions/DateTimePropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const Schemas_1 = require("./Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const ItemSchema_1 = require("./ItemSchema");
/**
 * Field URIs for PostItem.
 */
var FieldUris;
(function (FieldUris) {
    FieldUris.PostedTime = "postitem:PostedTime";
})(FieldUris || (FieldUris = {}));
/**
 * Represents the schema for post items.
 */
class PostItemSchema extends ItemSchema_1.ItemSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(PostItemSchema, PostItemSchema.ConversationIndex);
        this.RegisterProperty(PostItemSchema, PostItemSchema.ConversationTopic);
        this.RegisterProperty(PostItemSchema, PostItemSchema.From);
        this.RegisterProperty(PostItemSchema, PostItemSchema.InternetMessageId);
        this.RegisterProperty(PostItemSchema, PostItemSchema.IsRead);
        this.RegisterProperty(PostItemSchema, PostItemSchema.PostedTime);
        this.RegisterProperty(PostItemSchema, PostItemSchema.References);
        this.RegisterProperty(PostItemSchema, PostItemSchema.Sender);
    }
}
exports.PostItemSchema = PostItemSchema;
/**
 * Defines the **ConversationIndex** property.
 */
PostItemSchema.ConversationIndex = Schemas_1.Schemas.EmailMessageSchema.ConversationIndex;
/**
 * Defines the **ConversationTopic** property.
 */
PostItemSchema.ConversationTopic = Schemas_1.Schemas.EmailMessageSchema.ConversationTopic;
/**
 * Defines the **From** property.
 */
PostItemSchema.From = Schemas_1.Schemas.EmailMessageSchema.From;
/**
 * Defines the **InternetMessageId** property.
 */
PostItemSchema.InternetMessageId = Schemas_1.Schemas.EmailMessageSchema.InternetMessageId;
/**
 * Defines the **IsRead** property.
 */
PostItemSchema.IsRead = Schemas_1.Schemas.EmailMessageSchema.IsRead;
/**
 * Defines the **PostedTime** property.
 */
PostItemSchema.PostedTime = new DateTimePropertyDefinition_1.DateTimePropertyDefinition("PostedTime", XmlElementNames_1.XmlElementNames.PostedTime, FieldUris.PostedTime, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1);
/**
 * Defines the **References** property.
 */
PostItemSchema.References = Schemas_1.Schemas.EmailMessageSchema.References;
/**
 * Defines the **Sender** property.
 */
PostItemSchema.Sender = Schemas_1.Schemas.EmailMessageSchema.Sender;
/**
 * @internal Instance of **PostItemSchema**
 */
PostItemSchema.Instance = new PostItemSchema();
//# sourceMappingURL=PostItemSchema.js.map