"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingMessageSchema = void 0;
const BoolPropertyDefinition_1 = require("../../../PropertyDefinitions/BoolPropertyDefinition");
const ComplexPropertyDefinition_1 = require("../../../PropertyDefinitions/ComplexPropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const GenericPropertyDefinition_1 = require("../../../PropertyDefinitions/GenericPropertyDefinition");
const ItemId_1 = require("../../../ComplexProperties/ItemId");
const MeetingResponseType_1 = require("../../../Enumerations/MeetingResponseType");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const Schemas_1 = require("./Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const EmailMessageSchema_1 = require("./EmailMessageSchema");
/**
 * Field URIs for MeetingMessage.
 */
var FieldUris;
(function (FieldUris) {
    FieldUris.AssociatedCalendarItemId = "meeting:AssociatedCalendarItemId";
    FieldUris.IsDelegated = "meeting:IsDelegated";
    FieldUris.IsOutOfDate = "meeting:IsOutOfDate";
    FieldUris.HasBeenProcessed = "meeting:HasBeenProcessed";
    FieldUris.ResponseType = "meeting:ResponseType";
    FieldUris.IsOrganizer = "cal:IsOrganizer";
})(FieldUris || (FieldUris = {}));
/**
 * Represents the schema for meeting messages.
 */
class MeetingMessageSchema extends EmailMessageSchema_1.EmailMessageSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.AssociatedAppointmentId);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.IsDelegated);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.IsOutOfDate);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.HasBeenProcessed);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.ResponseType);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.ICalUid);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.ICalRecurrenceId);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.ICalDateTimeStamp);
        this.RegisterProperty(MeetingMessageSchema, MeetingMessageSchema.IsOrganizer);
    }
}
exports.MeetingMessageSchema = MeetingMessageSchema;
/**
 * Defines the **AssociatedAppointmentId** property.
 */
MeetingMessageSchema.AssociatedAppointmentId = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("AssociatedCalendarItemId", XmlElementNames_1.XmlElementNames.AssociatedCalendarItemId, FieldUris.AssociatedCalendarItemId, PropertyDefinitionFlags_1.PropertyDefinitionFlags.None, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new ItemId_1.ItemId(); });
/**
 * Defines the **IsDelegated** property.
 */
MeetingMessageSchema.IsDelegated = new BoolPropertyDefinition_1.BoolPropertyDefinition("IsDelegated", XmlElementNames_1.XmlElementNames.IsDelegated, FieldUris.IsDelegated, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1);
/**
 * Defines the **IsOutOfDate** property.
 */
MeetingMessageSchema.IsOutOfDate = new BoolPropertyDefinition_1.BoolPropertyDefinition("IsOutOfDate", XmlElementNames_1.XmlElementNames.IsOutOfDate, FieldUris.IsOutOfDate, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1);
/**
 * Defines the **HasBeenProcessed** property.
 */
MeetingMessageSchema.HasBeenProcessed = new BoolPropertyDefinition_1.BoolPropertyDefinition("HasBeenProcessed", XmlElementNames_1.XmlElementNames.HasBeenProcessed, FieldUris.HasBeenProcessed, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1);
/**
 * Defines the **ResponseType** property.
 */
MeetingMessageSchema.ResponseType = new GenericPropertyDefinition_1.GenericPropertyDefinition("ResponseType", XmlElementNames_1.XmlElementNames.ResponseType, FieldUris.ResponseType, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, MeetingResponseType_1.MeetingResponseType);
/**
 * Defines the **ICalUid** property.
 */
MeetingMessageSchema.ICalUid = Schemas_1.Schemas.AppointmentSchema.ICalUid;
/**
 * Defines the **ICalRecurrenceId** property.
 */
MeetingMessageSchema.ICalRecurrenceId = Schemas_1.Schemas.AppointmentSchema.ICalRecurrenceId;
/**
 * Defines the **ICalDateTimeStamp** property.
 */
MeetingMessageSchema.ICalDateTimeStamp = Schemas_1.Schemas.AppointmentSchema.ICalDateTimeStamp;
/**
 * Defines the **IsOrganizer** property.
 */
MeetingMessageSchema.IsOrganizer = new GenericPropertyDefinition_1.GenericPropertyDefinition("IsOrganizer", XmlElementNames_1.XmlElementNames.IsOrganizer, "cal:IsOrganizer", PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanFind, ExchangeVersion_1.ExchangeVersion.Exchange2013, false //isNullable
);
/**
 * @internal Instance of **MeetingMessageSchema**
 */
MeetingMessageSchema.Instance = new MeetingMessageSchema();
//# sourceMappingURL=MeetingMessageSchema.js.map