"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingCancellationSchema = void 0;
const Schemas_1 = require("./Schemas");
const MeetingMessageSchema_1 = require("./MeetingMessageSchema");
/**
 * Represents the schema for meeting cancellation.
 */
class MeetingCancellationSchema extends MeetingMessageSchema_1.MeetingMessageSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.Start);
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.End);
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.Location);
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.Recurrence);
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.AppointmentType);
        this.RegisterProperty(MeetingCancellationSchema, MeetingCancellationSchema.EnhancedLocation);
    }
}
exports.MeetingCancellationSchema = MeetingCancellationSchema;
/**
 * Defines the **Start** property.
 */
MeetingCancellationSchema.Start = Schemas_1.Schemas.AppointmentSchema.Start;
/**
 * Defines the **End** property.
 */
MeetingCancellationSchema.End = Schemas_1.Schemas.AppointmentSchema.End;
/**
 * Defines the **Location** property.
 */
MeetingCancellationSchema.Location = Schemas_1.Schemas.AppointmentSchema.Location;
/**
 * Defines the **AppointmentType** property.
 */
MeetingCancellationSchema.AppointmentType = Schemas_1.Schemas.AppointmentSchema.AppointmentType;
/**
 * Defines the **Recurrence** property.
 */
MeetingCancellationSchema.Recurrence = Schemas_1.Schemas.AppointmentSchema.Recurrence;
/**
 * Defines the **EnhancedLocation** property.
 */
MeetingCancellationSchema.EnhancedLocation = Schemas_1.Schemas.AppointmentSchema.EnhancedLocation;
/**
 * @internal Instance of **MeetingCancellationSchema**
 */
MeetingCancellationSchema.Instance = new MeetingCancellationSchema();
//# sourceMappingURL=MeetingCancellationSchema.js.map