"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactGroupSchema = void 0;
const ComplexPropertyDefinition_1 = require("../../../PropertyDefinitions/ComplexPropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const GroupMemberCollection_1 = require("../../../ComplexProperties/GroupMemberCollection");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const Schemas_1 = require("./Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const ItemSchema_1 = require("./ItemSchema");
/**
 * Field URIs for Members.
 */
var FieldUris;
(function (FieldUris) {
    /**
     * FieldUri for members.
     */
    FieldUris.Members = "distributionlist:Members";
})(FieldUris || (FieldUris = {}));
/**
 * Represents the schema for contact groups.
 */
class ContactGroupSchema extends ItemSchema_1.ItemSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(ContactGroupSchema, ContactGroupSchema.DisplayName);
        this.RegisterProperty(ContactGroupSchema, ContactGroupSchema.FileAs);
        this.RegisterProperty(ContactGroupSchema, ContactGroupSchema.Members);
    }
}
exports.ContactGroupSchema = ContactGroupSchema;
/**
 * Defines the **DisplayName** property.
 */
ContactGroupSchema.DisplayName = Schemas_1.Schemas.ContactSchema.DisplayName;
/**
 * Defines the **FileAs** property.
 */
ContactGroupSchema.FileAs = Schemas_1.Schemas.ContactSchema.FileAs;
/**
 * Defines the **Members** property.
 */
ContactGroupSchema.Members = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("Members", XmlElementNames_1.XmlElementNames.Members, FieldUris.Members, PropertyDefinitionFlags_1.PropertyDefinitionFlags.AutoInstantiateOnRead | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanUpdate, ExchangeVersion_1.ExchangeVersion.Exchange2010, () => { return new GroupMemberCollection_1.GroupMemberCollection(); });
/**
 * @internal Instance of **ContactGroupSchema**
 */
ContactGroupSchema.Instance = new ContactGroupSchema();
//# sourceMappingURL=ContactGroupSchema.js.map