"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CancelMeetingMessageSchema = void 0;
const ComplexPropertyDefinition_1 = require("../../../PropertyDefinitions/ComplexPropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const MessageBody_1 = require("../../../ComplexProperties/MessageBody");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const Schemas_1 = require("./Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const ServiceObjectSchema_1 = require("./ServiceObjectSchema");
/**
 * Represents CancelMeetingMessage schema definition.
 */
class CancelMeetingMessageSchema extends ServiceObjectSchema_1.ServiceObjectSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(CancelMeetingMessageSchema, Schemas_1.Schemas.EmailMessageSchema.IsReadReceiptRequested);
        this.RegisterProperty(CancelMeetingMessageSchema, Schemas_1.Schemas.EmailMessageSchema.IsDeliveryReceiptRequested);
        this.RegisterProperty(CancelMeetingMessageSchema, Schemas_1.Schemas.ResponseObjectSchema.ReferenceItemId);
        this.RegisterProperty(CancelMeetingMessageSchema, CancelMeetingMessageSchema.Body);
    }
}
exports.CancelMeetingMessageSchema = CancelMeetingMessageSchema;
/**
 * Defines the **Body** property.
 */
CancelMeetingMessageSchema.Body = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("Body", XmlElementNames_1.XmlElementNames.NewBodyContent, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new MessageBody_1.MessageBody(); });
/**
 * @internal Instance of **CancelMeetingMessageSchema**
 */
CancelMeetingMessageSchema.Instance = new CancelMeetingMessageSchema();
//# sourceMappingURL=CancelMeetingMessageSchema.js.map