"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarResponseObjectSchema = void 0;
const Schemas_1 = require("./Schemas");
const ServiceObjectSchema_1 = require("./ServiceObjectSchema");
/**
 * Represents CalendarResponseObject schema definition.
 */
class CalendarResponseObjectSchema extends ServiceObjectSchema_1.ServiceObjectSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ItemSchema.ItemClass);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ItemSchema.Sensitivity);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ItemSchema.Body);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ItemSchema.Attachments);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ItemSchema.InternetMessageHeaders);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.Sender);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.ToRecipients);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.CcRecipients);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.BccRecipients);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.IsReadReceiptRequested);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.EmailMessageSchema.IsDeliveryReceiptRequested);
        this.RegisterProperty(CalendarResponseObjectSchema, Schemas_1.Schemas.ResponseObjectSchema.ReferenceItemId);
    }
}
exports.CalendarResponseObjectSchema = CalendarResponseObjectSchema;
/**
 * @internal Instance of **CalendarResponseObjectSchema**
 */
CalendarResponseObjectSchema.Instance = new CalendarResponseObjectSchema();
//# sourceMappingURL=CalendarResponseObjectSchema.js.map