"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CancelMeetingMessage = void 0;
const XmlElementNames_1 = require("../../XmlElementNames");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const Schemas_1 = require("../Schemas/Schemas");
const CalendarResponseMessageBase_1 = require("./CalendarResponseMessageBase");
/**
 * Represents a meeting cancellation message.
 *
 */
class CancelMeetingMessage extends CalendarResponseMessageBase_1.CalendarResponseMessageBase {
    /**
     * Gets or sets the body of the response.
     *
     */
    get Body() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.CancelMeetingMessageSchema.Body);
    }
    set Body(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.CancelMeetingMessageSchema.Body, value);
    }
    /**
     * Initializes a new instance of the **CancelMeetingMessage** class.
     *
     * @param   {Item}   referenceItem   The reference item.
     */
    constructor(referenceItem) {
        super(referenceItem);
    }
    /**
     * Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() { return Schemas_1.Schemas.CancelMeetingMessageSchema.Instance; }
    /**
     * Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.CancelCalendarItem; }
}
exports.CancelMeetingMessage = CancelMeetingMessage;
//# sourceMappingURL=CancelMeetingMessage.js.map