"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingMessage = void 0;
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const EmailMessage_1 = require("./EmailMessage");
/**
 * Represents a meeting-related message. Properties available on meeting messages are defined in the MeetingMessageSchema class.
 */
class MeetingMessage extends EmailMessage_1.EmailMessage {
    /**
     * Gets the Id of the appointment associated with the meeting message.
     */
    get AssociatedAppointmentId() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.AssociatedAppointmentId);
    }
    /**
     * Gets a value indicating whether the meeting message is delegated.
     */
    get IsDelegated() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.IsDelegated);
    }
    /**
     * Gets a value indicating whether the meeting message is out of date.
     */
    get IsOutOfDate() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.IsOutOfDate);
    }
    /**
     * Gets a value indicating whether the meeting message has been processed by Exchange (i.e. Exchange has noted the arrival of a meeting request and has created the associated meeting item in the calendar).
     */
    get HasBeenProcessed() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.HasBeenProcessed);
    }
    /**
     * Gets the isorganizer property for this meeting
     *
     * @Nullable
     */
    get IsOrganizer() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.IsOrganizer);
    }
    /**
     * Gets the type of response the meeting message represents.
     */
    get ResponseType() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.ResponseType);
    }
    /**
     * Gets the ICalendar Uid.
     */
    get ICalUid() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.ICalUid);
    }
    /**
     * Gets the ICalendar RecurrenceId.
     *
     * @Nullable
     */
    get ICalRecurrenceId() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.ICalRecurrenceId);
    }
    /**
     * Gets the ICalendar DateTimeStamp.
     */
    get ICalDateTimeStamp() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingMessageSchema.ICalDateTimeStamp);
    }
    constructor(serviceOrParentAttachment) {
        super(serviceOrParentAttachment);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, MeetingMessage);
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.MeetingMessageSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.MeetingMessage;
    }
}
exports.MeetingMessage = MeetingMessage;
//# sourceMappingURL=MeetingMessage.js.map