"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemInfo = void 0;
const XmlElementNames_1 = require("../../XmlElementNames");
const Appointment_1 = require("./Appointment");
const Contact_1 = require("./Contact");
const ContactGroup_1 = require("./ContactGroup");
const Conversation_1 = require("./Conversation");
const EmailMessage_1 = require("./EmailMessage");
const Item_1 = require("./Item");
const MeetingCancellation_1 = require("./MeetingCancellation");
const MeetingMessage_1 = require("./MeetingMessage");
const MeetingRequest_1 = require("./MeetingRequest");
const MeetingResponse_1 = require("./MeetingResponse");
const PostItem_1 = require("./PostItem");
const Task_1 = require("./Task");
const ServiceObjectInfo_1 = require("../ServiceObjectInfo");
/**
 ** this is partial section of CreateEwsObjectFromXmlElementName from serviceobjectinfo, other parts are moved to different object type like folderinfo etc.
 * this to is to avoid circular referencing with requirejs/commonjs/nodejs
 */
class ItemInfo extends ServiceObjectInfo_1.ServiceObjectInfo {
    InitializeServiceObjectClassMap() {
        // Appointment
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.CalendarItem, "Appointment", (srv) => { return new Appointment_1.Appointment(srv); }, (itemAttachment, isNew) => { return new Appointment_1.Appointment(itemAttachment, isNew); });
        // Contact
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Contact, "Contact", (srv) => { return new Contact_1.Contact(srv); }, (itemAttachment, isNew) => { return new Contact_1.Contact(itemAttachment); });
        // ContactGroup
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.DistributionList, "ContactGroup", (srv) => { return new ContactGroup_1.ContactGroup(srv); }, (itemAttachment, isNew) => { return new ContactGroup_1.ContactGroup(itemAttachment); });
        // Conversation
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Conversation, "Conversation", (srv) => { return new Conversation_1.Conversation(srv); }, null);
        // EmailMessage
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Message, "EmailMessage", (srv) => { return new EmailMessage_1.EmailMessage(srv); }, (itemAttachment, isNew) => { return new EmailMessage_1.EmailMessage(itemAttachment); });
        // Item
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Item, "Item", (srv) => { return new Item_1.Item(srv); }, (itemAttachment, isNew) => { return new Item_1.Item(itemAttachment); });
        // MeetingCancellation
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.MeetingCancellation, "MeetingCancellation", (srv) => { return new MeetingCancellation_1.MeetingCancellation(srv); }, (itemAttachment, isNew) => { return new MeetingCancellation_1.MeetingCancellation(itemAttachment); });
        // MeetingMessage
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.MeetingMessage, "MeetingMessage", (srv) => { return new MeetingMessage_1.MeetingMessage(srv); }, (itemAttachment, isNew) => { return new MeetingMessage_1.MeetingMessage(itemAttachment); });
        // MeetingRequest
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.MeetingRequest, "MeetingRequest", (srv) => { return new MeetingRequest_1.MeetingRequest(srv); }, (itemAttachment, isNew) => { return new MeetingRequest_1.MeetingRequest(itemAttachment); });
        // MeetingResponse
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.MeetingResponse, "MeetingResponse", (srv) => { return new MeetingResponse_1.MeetingResponse(srv); }, (itemAttachment, isNew) => { return new MeetingResponse_1.MeetingResponse(itemAttachment); });
        // PostItem
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.PostItem, "PostItem", (srv) => { return new PostItem_1.PostItem(srv); }, (itemAttachment, isNew) => { return new PostItem_1.PostItem(itemAttachment); });
        // Task
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Task, "Task", (srv) => { return new Task_1.Task(srv); }, (itemAttachment, isNew) => { return new Task_1.Task(itemAttachment); });
    }
}
exports.ItemInfo = ItemInfo;
//# sourceMappingURL=ItemInfo.js.map