"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncFolderHierarchyResponse = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const FolderChange_1 = require("../../Sync/FolderChange");
const SyncResponse_1 = require("./SyncResponse");
/**
 * Represents the response to a folder synchronization operation.
 *
 * @sealed
 */
class SyncFolderHierarchyResponse extends SyncResponse_1.SyncResponse {
    /**
     * @internal Gets a value indicating whether this request returns full or summary properties.
     *
     * @value	*true* if summary properties only; otherwise, *false*.
     */
    get SummaryPropertiesOnly() {
        return true;
    }
    /**
     * @internal Initializes a new instance of the **SyncFolderHierarchyResponse** class.
     *
     * @param   {PropertySet}   propertySet   PropertySet from request.
     */
    constructor(propertySet) {
        super(propertySet);
    }
    /**
     * @internal Creates an item change instance.
     *
     * @return  {ItemChange}      ItemChange instance
     */
    CreateChangeInstance() {
        return new FolderChange_1.FolderChange();
    }
    /**
     * @internal Gets the name of the change element.
     *
     * @return  {string}      Change element name.
     */
    GetChangeElementName() {
        return XmlElementNames_1.XmlElementNames.Folder;
    }
    /**
     * @internal Gets the name of the change id element.
     *
     * @return  {string}      Change id element name.
     */
    GetChangeIdElementName() {
        return XmlElementNames_1.XmlElementNames.FolderId;
    }
    /**
     * @internal Gets the name of the includes last in range XML element.
     *
     * @return  {string}      XML element name.
     */
    GetIncludesLastInRangeXmlElementName() {
        return XmlElementNames_1.XmlElementNames.IncludesLastFolderInRange;
    }
}
exports.SyncFolderHierarchyResponse = SyncFolderHierarchyResponse;
//# sourceMappingURL=SyncFolderHierarchyResponse.js.map