"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchMailboxesResponse = void 0;
const SearchMailboxesResult_1 = require("../../MailboxSearch/SearchMailboxesResult");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the SearchMailboxes response.
 *
 * @sealed
 */
class SearchMailboxesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **SearchMailboxesResponse** class.
     */
    constructor() {
        super();
        this.searchResult = null;
    }
    /**
     * Search mailboxes result
     */
    get SearchResult() {
        return this.searchResult;
    }
    /**@internal set*/
    set SearchResult(value) {
        this.searchResult = value;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        //super.ReadElementsFromXmlJsObject(jsObject, service);
        if (jsObject[XmlElementNames_1.XmlElementNames.SearchMailboxesResult]) {
            this.searchResult = SearchMailboxesResult_1.SearchMailboxesResult.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.SearchMailboxesResult], service);
        }
    }
}
exports.SearchMailboxesResponse = SearchMailboxesResponse;
//# sourceMappingURL=SearchMailboxesResponse.js.map