"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveCopyItemResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents a response to a Move or Copy operation.
 *
 */
class MoveCopyItemResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the *MoveCopyItemResponse* class.
     *
     */
    constructor() {
        super();
        this.item = null;
    }
    /**
     * Gets the copied or moved item. Item is null if the copy or move operation was between two mailboxes or between a mailbox and a public folder.
     *
     */
    get Item() {
        return this.item;
    }
    /**
     * @internal Gets Item instance.
     *
     * @param   {ExchangeService}   service          The service.
     * @param   {string}            xmlElementName   Name of the XML element.
     * @return  {Item}              Item.
     */
    GetObjectInstance(service, xmlElementName) {
        var itemInfo = new ItemInfo_1.ItemInfo();
        return itemInfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
    }
    /**
     * @internal Reads response elements from XML parsed to JS Object.
     *
     * @param   {any}               responseObject   The response object.
     * @param   {ExchangeService}   service          The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Items]) {
            //debug: check if this works
            var items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Items, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
            // We only receive the copied or moved items if the copy or move operation was within
            // a single mailbox. No item is returned if the operation is cross-mailbox, from a
            // mailbox to a public folder or from a public folder to a mailbox.
            this.item = items[0];
        }
    }
}
exports.MoveCopyItemResponse = MoveCopyItemResponse;
//# sourceMappingURL=MoveCopyItemResponse.js.map