"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveCopyFolderResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const FolderInfo_1 = require("../ServiceObjects/Folders/FolderInfo");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
class MoveCopyFolderResponse extends ServiceResponse_1.ServiceResponse {
    constructor() {
        super();
        this.folder = null;
    }
    get Folder() {
        return this.folder;
    }
    GetObjectInstance(service, xmlElementName) {
        var flinfo = new FolderInfo_1.FolderInfo();
        return flinfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
    }
    ReadElementsFromJson(responseObject, service) { throw new Error("MoveCopyFolderResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Folders]) {
            //debug: check if this works
            var folders = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Folders, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
            this.folder = folders[0];
        }
    }
}
exports.MoveCopyFolderResponse = MoveCopyFolderResponse;
//# sourceMappingURL=MoveCopyFolderResponse.js.map