"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserConfigurationResponse = void 0;
const EwsLogging_1 = require("../EwsLogging");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents a response to a GetUserConfiguration request.
 *
 * @sealed
 */
class GetUserConfigurationResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetUserConfigurationResponse** class.
     *
     * @param   {UserConfiguration}   userConfiguration   The userConfiguration.
     */
    constructor(userConfiguration) {
        super();
        this.userConfiguration = null;
        EwsLogging_1.EwsLogging.Assert(userConfiguration !== null, "GetUserConfigurationResponse.ctor", "userConfiguration is null");
        this.userConfiguration = userConfiguration;
    }
    /**
     * Gets the user configuration that was created.
     */
    get UserConfiguration() {
        return this.userConfiguration;
    }
    /**
     * @internal Reads response elements from XML parsed to JS Object.
     *
     * @param   {any}               responseObject   The response object.
     * @param   {ExchangeService}   service          The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.UserConfiguration.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.UserConfiguration], service);
    }
}
exports.GetUserConfigurationResponse = GetUserConfigurationResponse;
//# sourceMappingURL=GetUserConfigurationResponse.js.map