"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetServerTimeZonesResponse = void 0;
const ServiceResponse_1 = require("./ServiceResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const TimeZoneDefinition_1 = require("../../ComplexProperties/TimeZones/TimeZoneDefinition");
/**
 * internal Represents the response to a GetServerTimeZones request.
 */
class GetServerTimeZonesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetServerTimeZonesResponse** class.
     */
    constructor() {
        super();
        this.timeZones = [];
    }
    /**
     * Gets the time zones returned by the associated GetServerTimeZones request.
     * @value   The time zones.
     */
    get TimeZones() {
        return this.timeZones;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.TimeZoneDefinitions]) {
            for (let tzObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.TimeZoneDefinitions], XmlElementNames_1.XmlElementNames.TimeZoneDefinition)) {
                let timeZoneDefinition = new TimeZoneDefinition_1.TimeZoneDefinition();
                timeZoneDefinition.LoadFromXmlJsObject(tzObject, service);
                this.timeZones.push(timeZoneDefinition.ToTimeZoneInfo(service, true));
            }
        }
    }
}
exports.GetServerTimeZonesResponse = GetServerTimeZonesResponse;
//# sourceMappingURL=GetServerTimeZonesResponse.js.map