"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetSearchableMailboxesResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const FailedSearchMailbox_1 = require("../../MailboxSearch/FailedSearchMailbox");
const SearchableMailbox_1 = require("../../MailboxSearch/SearchableMailbox");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the GetSearchableMailboxes response.
 *
 * @sealed
 */
class GetSearchableMailboxesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetSearchableMailboxesResponse** class.
     */
    constructor() {
        super();
        this.searchableMailboxes = [];
        /**
         * Failed mailboxes
         */
        this.FailedMailboxes = null;
    }
    /**
     * Searchable mailboxes result
     */
    get SearchableMailboxes() {
        return this.searchableMailboxes;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        this.searchableMailboxes.splice(0);
        //super.ReadElementsFromXmlJsObject(jsObject, service);
        if (jsObject[XmlElementNames_1.XmlElementNames.SearchableMailboxes]) {
            for (let searchableMailboxObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.SearchableMailboxes], XmlElementNames_1.XmlElementNames.SearchableMailbox)) {
                this.searchableMailboxes.push(SearchableMailbox_1.SearchableMailbox.LoadFromXmlJsObject(searchableMailboxObject, service));
            }
        }
        if (jsObject[XmlElementNames_1.XmlElementNames.FailedMailboxes]) {
            this.FailedMailboxes = FailedSearchMailbox_1.FailedSearchMailbox.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.FailedMailboxes], service);
        }
    }
}
exports.GetSearchableMailboxesResponse = GetSearchableMailboxesResponse;
//# sourceMappingURL=GetSearchableMailboxesResponse.js.map