"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetRoomListsResponse = void 0;
const EmailAddress_1 = require("../../ComplexProperties/EmailAddress");
const EmailAddressCollection_1 = require("../../ComplexProperties/EmailAddressCollection");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a GetRoomLists operation.
 */
class GetRoomListsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetRoomListsResponse** class.
     */
    constructor() {
        super();
        this.roomLists = new EmailAddressCollection_1.EmailAddressCollection();
    }
    /**
     * Gets all room list returned
     */
    get RoomLists() {
        return this.roomLists;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.roomLists.Clear();
        let responses = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.RoomLists], XmlElementNames_1.XmlElementNames.Address);
        for (let response of responses) {
            let emailAddress = new EmailAddress_1.EmailAddress();
            emailAddress.LoadFromXmlJsObject(response, service);
            this.roomLists.Add(emailAddress);
        }
    }
}
exports.GetRoomListsResponse = GetRoomListsResponse;
//# sourceMappingURL=GetRoomListsResponse.js.map