"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetPasswordExpirationDateResponse = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
class GetPasswordExpirationDateResponse extends ServiceResponse_1.ServiceResponse {
    constructor() {
        super(...arguments);
        this.passwordExpirationDate = null;
    }
    get PasswordExpirationDate() {
        return this.passwordExpirationDate;
    }
    ReadElementsFromJson(responseObject, service) { throw new Error("GetPasswordExpirationDateResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.passwordExpirationDate = service.ConvertUniversalDateTimeStringToLocalDateTime(responseObject[XmlElementNames_1.XmlElementNames.PasswordExpirationDate]);
    }
}
exports.GetPasswordExpirationDateResponse = GetPasswordExpirationDateResponse;
//# sourceMappingURL=GetPasswordExpirationDateResponse.js.map